/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.transaction.client;

import com.hazelcast.client.ClientEndpoint;
import com.hazelcast.client.impl.client.CallableClientRequest;
import com.hazelcast.client.impl.client.SecureRequest;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.PortableReader;
import com.hazelcast.nio.serialization.PortableWriter;
import com.hazelcast.security.permission.TransactionPermission;
import com.hazelcast.transaction.TransactionContext;
import com.hazelcast.transaction.client.ClientTxnPortableHook;
import com.hazelcast.transaction.impl.xa.SerializableXID;
import com.hazelcast.transaction.impl.xa.TransactionAccessor;
import com.hazelcast.transaction.impl.xa.XAService;
import java.io.IOException;
import java.security.Permission;

public class CreateXATransactionRequest
extends CallableClientRequest
implements SecureRequest {
    SerializableXID xid;
    int timeout;

    public CreateXATransactionRequest() {
    }

    public CreateXATransactionRequest(SerializableXID xid, int timeout) {
        this.xid = xid;
        this.timeout = timeout;
    }

    public Object call() throws Exception {
        ClientEndpoint endpoint = this.getEndpoint();
        XAService xaService = (XAService)this.getService();
        TransactionContext context = xaService.newXATransactionContext(this.xid, this.timeout);
        TransactionAccessor.getTransaction(context).begin();
        endpoint.setTransactionContext(context);
        return context.getTxnId();
    }

    @Override
    public String getServiceName() {
        return "hz:impl:xaService";
    }

    @Override
    public int getFactoryId() {
        return ClientTxnPortableHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 5;
    }

    @Override
    public Permission getRequiredPermission() {
        return new TransactionPermission();
    }

    @Override
    public void write(PortableWriter writer) throws IOException {
        super.write(writer);
        writer.writeInt("t", this.timeout);
        ObjectDataOutput rawDataOutput = writer.getRawDataOutput();
        rawDataOutput.writeObject(this.xid);
    }

    @Override
    public void read(PortableReader reader) throws IOException {
        super.read(reader);
        this.timeout = reader.readInt("t");
        ObjectDataInput rawDataInput = reader.getRawDataInput();
        this.xid = (SerializableXID)rawDataInput.readObject();
    }
}

