/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.nio.tcp.iobalancer;

import com.hazelcast.instance.HazelcastThreadGroup;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.tcp.iobalancer.IOBalancer;
import com.hazelcast.util.EmptyStatement;
import java.util.concurrent.TimeUnit;

class IOBalancerThread
extends Thread {
    private static final String THREAD_NAME_PREFIX = "IOBalancerThread";
    private final IOBalancer ioBalancer;
    private final ILogger log;
    private final int migrationIntervalSeconds;

    IOBalancerThread(IOBalancer ioBalancer, int migrationIntervalSeconds, HazelcastThreadGroup threadGroup, ILogger log) {
        super(threadGroup.getInternalThreadGroup(), threadGroup.getThreadNamePrefix(THREAD_NAME_PREFIX));
        this.ioBalancer = ioBalancer;
        this.log = log;
        this.migrationIntervalSeconds = migrationIntervalSeconds;
    }

    @Override
    public void run() {
        try {
            this.log.finest("Starting IOBalancer thread");
            while (!Thread.interrupted()) {
                this.ioBalancer.checkReadHandlers();
                this.ioBalancer.checkWriteHandlers();
                TimeUnit.SECONDS.sleep(this.migrationIntervalSeconds);
            }
        }
        catch (InterruptedException e) {
            this.log.finest("IOBalancer thread stopped");
            EmptyStatement.ignore(e);
        }
    }
}

