/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.codec;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.util.ParameterUtil;
import com.hazelcast.cluster.MemberAttributeOperationType;
import com.hazelcast.cluster.client.MemberAttributeChange;

public final class MemberAttributeChangeCodec {
    private MemberAttributeChangeCodec() {
    }

    public static MemberAttributeChange decode(ClientMessage clientMessage) {
        String uuid = clientMessage.getStringUtf8();
        String key = clientMessage.getStringUtf8();
        MemberAttributeOperationType operationType = MemberAttributeOperationType.getValue(clientMessage.getInt());
        String value = null;
        if (operationType == MemberAttributeOperationType.PUT) {
            value = clientMessage.getStringUtf8();
        }
        return new MemberAttributeChange(uuid, operationType, key, value);
    }

    public static void encode(MemberAttributeChange memberAttributeChange, ClientMessage clientMessage) {
        clientMessage.set(memberAttributeChange.getUuid());
        clientMessage.set(memberAttributeChange.getKey());
        MemberAttributeOperationType operationType = memberAttributeChange.getOperationType();
        clientMessage.set(operationType.getId());
        if (operationType == MemberAttributeOperationType.PUT) {
            clientMessage.set(memberAttributeChange.getValue().toString());
        }
    }

    public static int calculateDataSize(MemberAttributeChange memberAttributeChange) {
        if (memberAttributeChange == null) {
            return 1;
        }
        int dataSize = ParameterUtil.calculateStringDataSize(memberAttributeChange.getUuid());
        dataSize += ParameterUtil.calculateStringDataSize(memberAttributeChange.getKey());
        dataSize += 4;
        MemberAttributeOperationType operationType = memberAttributeChange.getOperationType();
        if (operationType == MemberAttributeOperationType.PUT) {
            dataSize += ParameterUtil.calculateStringDataSize(memberAttributeChange.getValue().toString());
        }
        return dataSize;
    }
}

