/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.spi.impl;

import com.hazelcast.core.HazelcastException;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.Connection;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.spi.Operation;
import com.hazelcast.spi.ResponseHandler;
import com.hazelcast.spi.exception.ResponseAlreadySentException;
import com.hazelcast.spi.impl.operationservice.InternalOperationService;
import com.hazelcast.spi.impl.operationservice.impl.responses.ErrorResponse;
import com.hazelcast.spi.impl.operationservice.impl.responses.NormalResponse;
import com.hazelcast.spi.impl.operationservice.impl.responses.Response;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;

public final class ResponseHandlerFactory {
    private static final NoResponseHandler NO_RESPONSE_HANDLER = new NoResponseHandler();

    private ResponseHandlerFactory() {
    }

    public static void setRemoteResponseHandler(NodeEngine nodeEngine, Operation operation) {
        ResponseHandler responseHandler = ResponseHandlerFactory.createRemoteResponseHandler(nodeEngine, operation);
        operation.setResponseHandler(responseHandler);
    }

    public static ResponseHandler createRemoteResponseHandler(NodeEngine nodeEngine, Operation operation) {
        if (operation.getCallId() == 0L || operation.getCallId() == Long.MAX_VALUE) {
            if (operation.returnsResponse()) {
                throw new HazelcastException("Op: " + operation + " can not return response without call-id!");
            }
            return NO_RESPONSE_HANDLER;
        }
        return new RemoteInvocationResponseHandler(nodeEngine, operation);
    }

    public static ResponseHandler createEmptyResponseHandler() {
        return NO_RESPONSE_HANDLER;
    }

    public static ResponseHandler createErrorLoggingResponseHandler(ILogger logger) {
        return new ErrorLoggingResponseHandler(logger);
    }

    private static final class RemoteInvocationResponseHandler
    implements ResponseHandler {
        private static final AtomicIntegerFieldUpdater<RemoteInvocationResponseHandler> SENT = AtomicIntegerFieldUpdater.newUpdater(RemoteInvocationResponseHandler.class, "sent");
        private final NodeEngine nodeEngine;
        private final Operation operation;
        private volatile int sent;

        private RemoteInvocationResponseHandler(NodeEngine nodeEngine, Operation operation) {
            this.nodeEngine = nodeEngine;
            this.operation = operation;
        }

        @Override
        public void sendResponse(Object obj) {
            long callId = this.operation.getCallId();
            Connection conn = this.operation.getConnection();
            if (!SENT.compareAndSet(this, 0, 1) && !(obj instanceof Throwable)) {
                throw new ResponseAlreadySentException("NormalResponse already sent for call: " + callId + " to " + conn.getEndPoint() + ", current-response: " + obj);
            }
            Response response = obj instanceof Throwable ? new ErrorResponse((Throwable)obj, this.operation.getCallId(), this.operation.isUrgent()) : (!(obj instanceof Response) ? new NormalResponse(obj, this.operation.getCallId(), 0, this.operation.isUrgent()) : (Response)obj);
            InternalOperationService operationService = (InternalOperationService)this.nodeEngine.getOperationService();
            if (!operationService.send(response, this.operation.getCallerAddress())) {
                throw new HazelcastException("Cannot send response: " + obj + " to " + conn.getEndPoint());
            }
        }

        @Override
        public boolean isLocal() {
            return false;
        }
    }

    private static final class ErrorLoggingResponseHandler
    implements ResponseHandler {
        private final ILogger logger;

        private ErrorLoggingResponseHandler(ILogger logger) {
            this.logger = logger;
        }

        @Override
        public void sendResponse(Object obj) {
            if (obj instanceof Throwable) {
                Throwable t = (Throwable)obj;
                this.logger.severe(t);
            }
        }

        @Override
        public boolean isLocal() {
            return true;
        }
    }

    private static class NoResponseHandler
    implements ResponseHandler {
        private NoResponseHandler() {
        }

        @Override
        public void sendResponse(Object obj) {
        }

        @Override
        public boolean isLocal() {
            return false;
        }
    }
}

