/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.data;

import java.io.IOException;
import org.jrobin.core.FetchData;
import org.jrobin.core.RrdException;
import org.jrobin.core.Util;
import org.jrobin.data.Aggregates;
import org.jrobin.data.Aggregator;
import org.jrobin.data.Source;

class Def
extends Source {
    private String path;
    private String dsName;
    private String consolFun;
    private String backend;
    private FetchData fetchData;

    Def(String string, FetchData fetchData) {
        this(string, null, string, null, null);
        this.setFetchData(fetchData);
    }

    Def(String string, String string2, String string3, String string4) {
        this(string, string2, string3, string4, null);
    }

    Def(String string, String string2, String string3, String string4, String string5) {
        super(string);
        this.path = string2;
        this.dsName = string3;
        this.consolFun = string4;
        this.backend = string5;
    }

    String getPath() {
        return this.path;
    }

    String getCanonicalPath() throws IOException {
        return Util.getCanonicalPath(this.path);
    }

    String getDsName() {
        return this.dsName;
    }

    String getConsolFun() {
        return this.consolFun;
    }

    String getBackend() {
        return this.backend;
    }

    boolean isCompatibleWith(Def def) throws IOException {
        return this.getCanonicalPath().equals(def.getCanonicalPath()) && this.getConsolFun().equals(def.consolFun) && (this.backend == null && def.backend == null || this.backend != null && def.backend != null && this.backend.equals(def.backend));
    }

    void setFetchData(FetchData fetchData) {
        this.fetchData = fetchData;
    }

    long[] getRrdTimestamps() {
        return this.fetchData.getTimestamps();
    }

    double[] getRrdValues() throws RrdException {
        return this.fetchData.getValues(this.dsName);
    }

    long getArchiveEndTime() {
        return this.fetchData.getArcEndTime();
    }

    long getFetchStep() {
        return this.fetchData.getStep();
    }

    Aggregates getAggregates(long l, long l2) throws RrdException {
        long[] lArray = this.getRrdTimestamps();
        double[] dArray = this.getRrdValues();
        Aggregator aggregator = new Aggregator(lArray, dArray);
        return aggregator.getAggregates(l, l2);
    }

    double getPercentile(long l, long l2, double d) throws RrdException {
        long[] lArray = this.getRrdTimestamps();
        double[] dArray = this.getRrdValues();
        Aggregator aggregator = new Aggregator(lArray, dArray);
        return aggregator.getPercentile(l, l2, d);
    }

    boolean isLoaded() {
        return this.fetchData != null;
    }
}

