/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.jdbc;

import com.mysql.jdbc.SocketFactory;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.Socket;
import java.net.SocketException;
import java.util.Properties;

public class StandardSocketFactory
implements SocketFactory {
    protected Socket rawSocket = null;
    protected String host = null;
    protected int port = 3306;
    static /* synthetic */ Class class$java$net$Socket;
    static /* synthetic */ Class class$java$lang$String;

    public Socket afterHandshake() throws SocketException, IOException {
        return this.rawSocket;
    }

    public Socket beforeHandshake() throws SocketException, IOException {
        return this.rawSocket;
    }

    public Socket connect(String host, int portNumber, Properties props) throws SocketException, IOException {
        if (props != null) {
            this.host = host;
            this.port = portNumber;
            boolean hasConnectTimeoutMethod = false;
            Method connectWithTimeoutMethod = null;
            try {
                Class<?> socketAddressClass = Class.forName("java.net.SocketAddress");
                connectWithTimeoutMethod = (class$java$net$Socket == null ? (class$java$net$Socket = StandardSocketFactory.class$("java.net.Socket")) : class$java$net$Socket).getMethod("connect", socketAddressClass, Integer.TYPE);
                hasConnectTimeoutMethod = true;
            }
            catch (NoClassDefFoundError noClassDefFound) {
                hasConnectTimeoutMethod = false;
            }
            catch (NoSuchMethodException noSuchMethodEx) {
                hasConnectTimeoutMethod = false;
            }
            catch (Throwable catchAll) {
                hasConnectTimeoutMethod = false;
            }
            int connectTimeout = 0;
            String connectTimeoutStr = props.getProperty("connectTimeout");
            if (connectTimeoutStr != null) {
                try {
                    connectTimeout = Integer.parseInt(connectTimeoutStr);
                }
                catch (NumberFormatException nfe) {
                    throw new SocketException("Illegal value '" + connectTimeoutStr + "' for connectTimeout");
                }
            }
            if (this.host != null) {
                if (!hasConnectTimeoutMethod || connectTimeout == 0) {
                    this.rawSocket = new Socket(this.host, this.port);
                } else {
                    try {
                        Class<?> inetSocketAddressClass = Class.forName("java.net.InetSocketAddress");
                        Constructor<?> addrConstructor = inetSocketAddressClass.getConstructor(class$java$lang$String == null ? (class$java$lang$String = StandardSocketFactory.class$("java.lang.String")) : class$java$lang$String, Integer.TYPE);
                        Object sockAddr = addrConstructor.newInstance(this.host, new Integer(this.port));
                        this.rawSocket = new Socket();
                        connectWithTimeoutMethod.invoke((Object)this.rawSocket, sockAddr, new Integer(connectTimeout));
                    }
                    catch (Throwable t) {
                        if (t != null) {
                            throw new SocketException(t.toString());
                        }
                        throw new SocketException("General Socket Exception");
                    }
                }
                try {
                    this.rawSocket.setTcpNoDelay(true);
                }
                catch (Exception ex) {
                    // empty catch block
                }
                return this.rawSocket;
            }
        }
        throw new SocketException("Unable to create socket");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

