/*
 * Decompiled with CFR 0.152.
 */
package com.oopsconsultancy.xmltask;

import com.oopsconsultancy.xmltask.Action;
import com.oopsconsultancy.xmltask.BufferStore;
import com.oopsconsultancy.xmltask.XPathAnalyser;
import com.oopsconsultancy.xmltask.XPathAnalyserClient;
import com.oopsconsultancy.xmltask.XPathAnalyserFactory;
import com.oopsconsultancy.xmltask.ant.Param;
import com.oopsconsultancy.xmltask.ant.XmlTask;
import java.util.Iterator;
import java.util.List;
import org.apache.tools.ant.taskdefs.Ant;
import org.apache.tools.ant.taskdefs.Property;
import org.w3c.dom.Node;

public class CallAction
extends Action
implements XPathAnalyserClient {
    private final String target;
    private final XmlTask task;
    private final boolean inheritAll;
    private final boolean inheritRefs;
    private final String buffer;
    private final List params;
    private Ant callee;

    public CallAction(String target, XmlTask task, boolean inheritAll, boolean inheritRefs, String buffer, List params) {
        this.target = target;
        this.task = task;
        this.inheritAll = inheritAll;
        this.inheritRefs = inheritRefs;
        this.buffer = buffer;
        this.params = params;
    }

    public void init() {
        this.callee = (Ant)this.task.getProject().createTask("ant");
        this.callee.setOwningTarget(this.task.getOwningTarget());
        this.callee.setTaskName(this.task.getTaskName());
        this.callee.setLocation(this.task.getLocation());
        this.callee.init();
    }

    public void applyNode(Node n, Object callback) {
        Param param = (Param)callback;
        param.set(this.task, n.getNodeValue());
    }

    public void applyNode(String str, Object callback) {
        Param param = (Param)callback;
        param.set(this.task, str);
    }

    public boolean apply(Node node) throws Exception {
        if (this.callee == null) {
            this.init();
        }
        this.log("Calling target " + this.target + " for " + node + (this.buffer != null ? " (in buffer " + this.buffer : ""), 3);
        if (this.buffer != null) {
            BufferStore.set(this.buffer, node, false, this.task);
        }
        if (this.params != null) {
            Iterator i = this.params.iterator();
            while (i.hasNext()) {
                String val;
                Param param = (Param)i.next();
                if (param.getPath() != null) {
                    XPathAnalyser xpa = XPathAnalyserFactory.getAnalyser();
                    xpa.registerClient(this, param);
                    xpa.analyse(node, param.getPath());
                }
                if ((val = param.getValue()) == null) continue;
                Property p = this.callee.createProperty();
                p.setName(param.getName());
                p.setValue(param.getValue());
            }
        }
        this.callee.setAntfile(this.task.getProject().getProperty("ant.file"));
        this.callee.setTarget(this.target);
        this.callee.setInheritAll(this.inheritAll);
        this.callee.setInheritRefs(this.inheritRefs);
        this.callee.execute();
        return true;
    }

    public String toString() {
        return "CallAction(" + this.target + ")";
    }

    private void log(String msg, int level) {
        if (this.task != null) {
            this.task.log(msg, level);
        } else {
            System.out.println(msg);
        }
    }
}

