/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.ProjectComponent;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.filters.util.ChainReaderHelper;
import org.apache.tools.ant.taskdefs.FixCRLF;
import org.apache.tools.ant.taskdefs.LogOutputStream;
import org.apache.tools.ant.types.AbstractFileSet;
import org.apache.tools.ant.types.FileList;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.FilterChain;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.util.FileUtils;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Concat
extends Task {
    private static final int BUFFER_SIZE = 8192;
    private static FileUtils fileUtils = FileUtils.newFileUtils();
    private File destinationFile;
    private boolean append;
    private String encoding;
    private String outputEncoding;
    private boolean binary;
    private StringBuffer textBuffer;
    private Vector sources;
    private Vector filterChains;
    private boolean forceOverwrite;
    private TextElement footer;
    private TextElement header;
    private boolean fixLastLine;
    private String eolString;
    private Writer outputWriter;
    private Vector sourceFiles;

    public void setDestfile(File file) {
        this.destinationFile = file;
    }

    public void setAppend(boolean bl) {
        this.append = bl;
    }

    public void setEncoding(String string) {
        this.encoding = string;
        if (this.outputEncoding == null) {
            this.outputEncoding = string;
        }
    }

    public void setOutputEncoding(String string) {
        this.outputEncoding = string;
    }

    public void setForce(boolean bl) {
        this.forceOverwrite = bl;
    }

    public Path createPath() {
        Path path = new Path(this.getProject());
        this.sources.addElement(path);
        return path;
    }

    public void addFileset(FileSet fileSet) {
        this.sources.addElement(fileSet);
    }

    public void addFilelist(FileList fileList) {
        this.sources.addElement(fileList);
    }

    public void addFilterChain(FilterChain filterChain) {
        if (this.filterChains == null) {
            this.filterChains = new Vector();
        }
        this.filterChains.addElement(filterChain);
    }

    public void addText(String string) {
        if (this.textBuffer == null) {
            this.textBuffer = new StringBuffer(string.length());
        }
        this.textBuffer.append(string);
    }

    public void addHeader(TextElement textElement) {
        this.header = textElement;
    }

    public void addFooter(TextElement textElement) {
        this.footer = textElement;
    }

    public void setFixLastLine(boolean bl) {
        this.fixLastLine = bl;
    }

    public void setEol(FixCRLF.CrLf crLf) {
        String string = crLf.getValue();
        if (string.equals("cr") || string.equals("mac")) {
            this.eolString = "\r";
        } else if (string.equals("lf") || string.equals("unix")) {
            this.eolString = "\n";
        } else if (string.equals("crlf") || string.equals("dos")) {
            this.eolString = "\r\n";
        }
    }

    public void setWriter(Writer writer) {
        this.outputWriter = writer;
    }

    public void setBinary(boolean bl) {
        this.binary = bl;
    }

    public void execute() {
        Object object;
        this.sanitizeText();
        if (this.binary) {
            if (this.destinationFile == null) {
                throw new BuildException("DestFile attribute is required for binary concatenation");
            }
            if (this.textBuffer != null) {
                throw new BuildException("Nested text is incompatible with binary concatenation");
            }
            if (this.encoding != null || this.outputEncoding != null) {
                throw new BuildException("Seting input or output encoding is incompatible with binary concatenation");
            }
            if (this.filterChains != null) {
                throw new BuildException("Setting filters is incompatible with binary concatenation");
            }
            if (this.fixLastLine) {
                throw new BuildException("Setting fixlastline is incompatible with binary concatenation");
            }
            if (this.header != null || this.footer != null) {
                throw new BuildException("Nested header or footer is incompatible with binary concatenation");
            }
        }
        if (this.destinationFile != null && this.outputWriter != null) {
            throw new BuildException("Cannot specify both a destination file and an output writer");
        }
        if (this.sources.size() == 0 && this.textBuffer == null) {
            throw new BuildException("At least one file must be provided, or some text.");
        }
        if (this.sources.size() > 0 && this.textBuffer != null) {
            throw new BuildException("Cannot include inline text when using filesets.");
        }
        Enumeration enumeration = this.sources.elements();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            if (e instanceof Path) {
                object = (Path)e;
                this.checkAddFiles(null, ((Path)object).list());
                continue;
            }
            if (e instanceof FileSet) {
                object = (FileSet)e;
                DirectoryScanner directoryScanner = ((AbstractFileSet)object).getDirectoryScanner(this.getProject());
                this.checkAddFiles(((AbstractFileSet)object).getDir(this.getProject()), directoryScanner.getIncludedFiles());
                continue;
            }
            if (!(e instanceof FileList)) continue;
            object = (FileList)e;
            this.checkAddFiles(((FileList)object).getDir(this.getProject()), ((FileList)object).getFiles(this.getProject()));
        }
        if (this.destinationFile != null && !this.forceOverwrite && this.sourceFiles.size() > 0 && this.destinationFile.exists()) {
            boolean bl = false;
            int n = 0;
            while (n < this.sourceFiles.size()) {
                object = (File)this.sourceFiles.elementAt(n);
                if (((File)object).lastModified() > this.destinationFile.lastModified()) {
                    bl = true;
                    break;
                }
                ++n;
            }
            if (!bl) {
                this.log(this.destinationFile + " is up-to-date.", 3);
                return;
            }
        }
        if (this.textBuffer == null && this.sourceFiles.size() == 0 && this.header == null && this.footer == null) {
            this.log("No existing files and no nested text, doing nothing", 2);
            return;
        }
        if (this.binary) {
            this.binaryCat();
        } else {
            this.cat();
        }
    }

    public void reset() {
        this.append = false;
        this.forceOverwrite = true;
        this.destinationFile = null;
        this.encoding = null;
        this.outputEncoding = null;
        this.fixLastLine = false;
        this.sources.removeAllElements();
        this.sourceFiles.removeAllElements();
        this.filterChains = null;
        this.footer = null;
        this.header = null;
    }

    private final void checkAddFiles(File file, String[] stringArray) {
        int n = 0;
        while (n < stringArray.length) {
            File file2 = new File(file, stringArray[n]);
            if (!file2.exists()) {
                this.log("File " + file2 + " does not exist.", 0);
            } else {
                if (this.destinationFile != null && fileUtils.fileNameEquals(this.destinationFile, file2)) {
                    throw new BuildException("Input file \"" + file2 + "\" is the same as the output file.");
                }
                this.sourceFiles.addElement(file2);
            }
            ++n;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void binaryCat() {
        FileOutputStream fileOutputStream;
        block23: {
            this.log("Binary concatenation of " + this.sourceFiles.size() + " files to " + this.destinationFile);
            fileOutputStream = null;
            FileInputStream fileInputStream = null;
            byte[] byArray = new byte[8192];
            try {
                try {
                    fileOutputStream = new FileOutputStream(this.destinationFile);
                }
                catch (Exception exception) {
                    throw new BuildException("Unable to open " + this.destinationFile + " for writing", exception);
                }
                Iterator iterator = this.sourceFiles.iterator();
                while (iterator.hasNext()) {
                    File file = (File)iterator.next();
                    try {
                        fileInputStream = new FileInputStream(file);
                    }
                    catch (Exception exception) {
                        throw new BuildException("Unable to open input file " + file, exception);
                    }
                    int n = 0;
                    do {
                        try {
                            n = fileInputStream.read(byArray, 0, byArray.length);
                        }
                        catch (Exception exception) {
                            throw new BuildException("Unable to read from " + file, exception);
                        }
                        try {
                            if (n <= 0) continue;
                            fileOutputStream.write(byArray, 0, n);
                        }
                        catch (Exception exception) {
                            throw new BuildException("Unable to write to " + this.destinationFile, exception);
                        }
                    } while (n > 0);
                    try {
                        fileInputStream.close();
                    }
                    catch (Exception exception) {
                        throw new BuildException("Unable to close " + file, exception);
                    }
                    fileInputStream = null;
                }
            }
            catch (Throwable throwable) {
                Object var5_13 = null;
                if (fileInputStream != null) {
                    try {
                        fileInputStream.close();
                    }
                    catch (Throwable throwable2) {}
                }
                if (fileOutputStream == null) throw throwable;
                try {
                    fileOutputStream.close();
                    throw throwable;
                }
                catch (Exception exception) {
                    throw new BuildException("Unable to close " + this.destinationFile, exception);
                }
            }
            {
                Object var5_14 = null;
                if (fileInputStream == null) break block23;
            }
            try {}
            catch (Throwable throwable) {}
            fileInputStream.close();
        }
        if (fileOutputStream == null) return;
        try {}
        catch (Exception exception) {
            throw new BuildException("Unable to close " + this.destinationFile, exception);
        }
        fileOutputStream.close();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void cat() {
        OutputStream outputStream;
        block25: {
            outputStream = null;
            Reader reader = null;
            char[] cArray = new char[8192];
            try {
                try {
                    PrintWriter printWriter = null;
                    if (this.outputWriter != null) {
                        printWriter = new PrintWriter(this.outputWriter);
                    } else {
                        if (this.destinationFile == null) {
                            outputStream = new LogOutputStream(this, 1);
                        } else {
                            File file = fileUtils.getParentFile(this.destinationFile);
                            if (!file.exists()) {
                                file.mkdirs();
                            }
                            outputStream = new FileOutputStream(this.destinationFile.getAbsolutePath(), this.append);
                        }
                        printWriter = this.outputEncoding == null ? new PrintWriter(new BufferedWriter(new OutputStreamWriter(outputStream))) : new PrintWriter(new BufferedWriter(new OutputStreamWriter(outputStream, this.outputEncoding)));
                    }
                    if (this.header != null) {
                        if (this.header.getFiltering()) {
                            this.concatenate(cArray, printWriter, new StringReader(this.header.getValue()));
                        } else {
                            printWriter.print(this.header.getValue());
                        }
                    }
                    reader = this.textBuffer != null ? new StringReader(this.getProject().replaceProperties(this.textBuffer.substring(0))) : new MultiReader();
                    this.concatenate(cArray, printWriter, reader);
                    if (this.footer != null) {
                        if (this.footer.getFiltering()) {
                            this.concatenate(cArray, printWriter, new StringReader(this.footer.getValue()));
                        } else {
                            printWriter.print(this.footer.getValue());
                        }
                    }
                    printWriter.flush();
                    if (outputStream != null) {
                        outputStream.flush();
                    }
                }
                catch (IOException iOException) {
                    throw new BuildException("Error while concatenating: " + iOException.getMessage(), iOException);
                }
            }
            catch (Throwable throwable) {
                Object var5_8 = null;
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException iOException) {}
                }
                if (outputStream == null) throw throwable;
                try {
                    outputStream.close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            {
                Object var5_9 = null;
                if (reader == null) break block25;
            }
            try {}
            catch (IOException iOException) {}
            reader.close();
        }
        if (outputStream == null) return;
        try {}
        catch (IOException iOException) {
            return;
        }
        outputStream.close();
    }

    private final void concatenate(char[] cArray, Writer writer, Reader reader) throws IOException {
        int n;
        if (this.filterChains != null) {
            ChainReaderHelper chainReaderHelper = new ChainReaderHelper();
            chainReaderHelper.setBufferSize(8192);
            chainReaderHelper.setPrimaryReader(reader);
            chainReaderHelper.setFilterChains(this.filterChains);
            chainReaderHelper.setProject(this.getProject());
            reader = new BufferedReader(chainReaderHelper.getAssembledReader());
        }
        while ((n = reader.read(cArray, 0, cArray.length)) != -1) {
            writer.write(cArray, 0, n);
        }
        writer.flush();
    }

    private final void sanitizeText() {
        if (this.textBuffer != null && this.textBuffer.substring(0).trim().length() == 0) {
            this.textBuffer = null;
        }
    }

    static /* synthetic */ FileUtils access$1() {
        return fileUtils;
    }

    private final /* synthetic */ void this() {
        this.destinationFile = null;
        this.append = false;
        this.encoding = null;
        this.outputEncoding = null;
        this.binary = false;
        this.sources = new Vector();
        this.filterChains = null;
        this.forceOverwrite = true;
        this.fixLastLine = false;
        this.eolString = System.getProperty("line.separator");
        this.outputWriter = null;
        this.sourceFiles = new Vector();
    }

    public Concat() {
        this.this();
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static class TextElement
    extends ProjectComponent {
        private String value;
        private boolean trimLeading;
        private boolean trim;
        private boolean filtering;
        private String encoding;

        public void setFiltering(boolean bl) {
            this.filtering = bl;
        }

        private final boolean getFiltering() {
            return this.filtering;
        }

        public void setEncoding(String string) {
            this.encoding = string;
        }

        /*
         * Exception decompiling
         */
        public void setFile(File var1_1) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [3 : 140->144)] java.lang.Throwable
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        public void addText(String string) {
            this.value = this.value + this.getProject().replaceProperties(string);
        }

        public void setTrimLeading(boolean bl) {
            this.trimLeading = bl;
        }

        public void setTrim(boolean bl) {
            this.trim = bl;
        }

        public String getValue() {
            if (this.value == null) {
                this.value = "";
            }
            if (this.value.trim().length() == 0) {
                this.value = "";
            }
            if (this.trimLeading) {
                char[] cArray = this.value.toCharArray();
                StringBuffer stringBuffer = new StringBuffer(cArray.length);
                boolean bl = true;
                int n = 0;
                while (n < cArray.length) {
                    char c = cArray[n++];
                    if (bl) {
                        if (c == ' ' || c == '\t') continue;
                        bl = false;
                    }
                    stringBuffer.append(c);
                    if (c != '\n' && c != '\r') continue;
                    bl = true;
                }
                this.value = stringBuffer.toString();
            }
            if (this.trim) {
                this.value = this.value.trim();
            }
            return this.value;
        }

        private final /* synthetic */ void this() {
            this.value = "";
            this.trimLeading = false;
            this.trim = false;
            this.filtering = true;
            this.encoding = null;
        }

        public TextElement() {
            this.this();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class MultiReader
    extends Reader {
        private int pos;
        private Reader reader;
        private int lastPos;
        private char[] lastChars;
        private boolean needAddSeparator;

        private final Reader getReader() throws IOException {
            if (this.reader == null) {
                Concat.this.log("Concating file " + Concat.this.sourceFiles.elementAt(this.pos), 3);
                this.reader = Concat.this.encoding == null ? new BufferedReader(new FileReader((File)Concat.this.sourceFiles.elementAt(this.pos))) : new BufferedReader(new InputStreamReader((InputStream)new FileInputStream((File)Concat.this.sourceFiles.elementAt(this.pos)), Concat.this.encoding));
                int n = 0;
                while (n < this.lastChars.length) {
                    this.lastChars[n] = '\u0000';
                    ++n;
                }
            }
            return this.reader;
        }

        /*
         * Unable to fully structure code
         */
        public int read() throws IOException {
            if (!this.needAddSeparator) ** GOTO lbl18
            var1_1 = Concat.access$0(Concat.this).charAt(this.lastPos++);
            if (this.lastPos >= Concat.access$0(Concat.this).length()) {
                this.lastPos = 0;
                this.needAddSeparator = false;
            }
            return var1_1;
lbl-1000:
            // 1 sources

            {
                var1_2 = this.getReader().read();
                if (var1_2 == -1) {
                    this.reader.close();
                    this.reader = null;
                    if (Concat.access$4(Concat.this) && this.isMissingEndOfLine()) {
                        this.needAddSeparator = true;
                        this.lastPos = 0;
                    }
                } else {
                    this.addLastChar((char)var1_2);
                    return var1_2;
                }
                ++this.pos;
lbl18:
                // 2 sources

                ** while (this.pos < Concat.access$2((Concat)Concat.this).size())
            }
lbl19:
            // 1 sources

            return -1;
        }

        public int read(char[] cArray, int n, int n2) throws IOException {
            int n3 = 0;
            while (this.pos < Concat.this.sourceFiles.size() || this.needAddSeparator) {
                if (this.needAddSeparator) {
                    cArray[n] = Concat.this.eolString.charAt(this.lastPos++);
                    if (this.lastPos >= Concat.this.eolString.length()) {
                        this.lastPos = 0;
                        this.needAddSeparator = false;
                        ++this.pos;
                    }
                    ++n;
                    ++n3;
                    if (--n2 != 0) continue;
                    return n3;
                }
                int n4 = this.getReader().read(cArray, n, n2);
                if (n4 == -1 || n4 == 0) {
                    this.reader.close();
                    this.reader = null;
                    if (Concat.this.fixLastLine && this.isMissingEndOfLine()) {
                        this.needAddSeparator = true;
                        this.lastPos = 0;
                        continue;
                    }
                    ++this.pos;
                    continue;
                }
                if (Concat.this.fixLastLine) {
                    int n5 = n4;
                    while (n5 > n4 - this.lastChars.length) {
                        if (n5 <= 0) break;
                        this.addLastChar(cArray[n + n5 - 1]);
                        --n5;
                    }
                }
                n += n4;
                n3 += n4;
                if ((n2 -= n4) != 0) continue;
                return n3;
            }
            if (n3 == 0) {
                return -1;
            }
            return n3;
        }

        public void close() throws IOException {
            if (this.reader != null) {
                this.reader.close();
            }
        }

        private final void addLastChar(char c) {
            int n = this.lastChars.length - 2;
            while (n >= 0) {
                this.lastChars[n] = this.lastChars[n + 1];
                --n;
            }
            this.lastChars[this.lastChars.length - 1] = c;
        }

        private final boolean isMissingEndOfLine() {
            int n = 0;
            while (n < this.lastChars.length) {
                if (this.lastChars[n] != Concat.this.eolString.charAt(n)) {
                    return true;
                }
                ++n;
            }
            return false;
        }

        private final /* synthetic */ void this() {
            this.pos = 0;
            this.reader = null;
            this.lastPos = 0;
            this.lastChars = new char[Concat.this.eolString.length()];
            this.needAddSeparator = false;
        }

        private MultiReader() {
            this.this();
        }
    }
}

