/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.frontend.screens;

import com.install4j.api.DirectoryValidator;
import com.install4j.runtime.installer.Installer;
import com.install4j.runtime.installer.InstallerUtil;
import com.install4j.runtime.installer.config.InstallerConfig;
import com.install4j.runtime.installer.frontend.InstallerScreen;
import com.install4j.runtime.installer.frontend.InstallerWizard;
import com.install4j.runtime.installer.frontend.components.DirectoryChooser;
import com.install4j.runtime.installer.frontend.components.NextScreenListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.event.ActionEvent;
import java.io.File;
import java.text.MessageFormat;
import java.text.NumberFormat;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class LocationScreen
extends InstallerScreen
implements NextScreenListener,
DirectoryChooser.InternalValidator {
    private DirectoryChooser directoryChooser;
    private DirectoryValidator directoryValidator;
    private boolean directoryValidatorInitialized = false;
    private JPanel chooserWrapperPanel;

    public LocationScreen(InstallerWizard installerWizard) {
        super(installerWizard);
        this.initScreen();
    }

    public void nextScreen() {
        if (this.btnForward.isEnabled()) {
            this.actionPerformed(new ActionEvent(this.btnForward, 0, null));
        }
    }

    public File getDestDir() {
        this.initDirectoryChooser();
        File file = this.directoryChooser.getSelectedDirectory();
        if (this.getDirectoryValidator() != null) {
            return this.getDirectoryValidator().getInstallationDirectory(file, this.getInstallerWizard().getInstaller().getDefaultDirectory().getName());
        }
        return file;
    }

    public File getSelectedDir() {
        this.initDirectoryChooser();
        return this.directoryChooser.getSelectedDirectory();
    }

    public void activate() {
        this.initDirectoryChooser();
        super.activate();
        this.directoryChooser.focusTextField();
    }

    private void initDirectoryChooser() {
        String string;
        File file;
        boolean bl;
        if (this.directoryChooser != null) {
            return;
        }
        File file2 = this.getInstallerWizard().getInstaller().getDefaultDirectory();
        InstallerConfig installerConfig = InstallerConfig.getCurrentInstance();
        boolean bl2 = bl = installerConfig.isSuggestAppDir() && installerConfig.getInstallerType() != 2;
        if (bl) {
            file = file2.getParentFile();
            string = file2.getName();
        } else {
            file = file2;
            string = null;
        }
        this.directoryChooser = new DirectoryChooser(file, string, this, this);
        this.chooserWrapperPanel.add((Component)this.directoryChooser, "Center");
    }

    protected boolean checkCompleted() {
        boolean bl;
        boolean bl2 = bl = this.directoryChooser.checkSelectedDirectory() && super.checkCompleted();
        if (bl) {
            File file = this.getDestDir();
            return InstallerUtil.checkWritable(file, this);
        }
        return false;
    }

    protected void addScreenContent(JPanel jPanel, GridBagConstraints gridBagConstraints) {
        this.addDisplayTextArea(MessageFormat.format(this.messages.getString("SelectDirLabel"), this.getApplicationName()), jPanel, gridBagConstraints);
        boolean bl = InstallerConfig.getCurrentInstance().isShowNeededSpace();
        if (!bl) {
            gridBagConstraints.insets.bottom = 5;
        }
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        jPanel.add((Component)this.chooserWrapperPanel, gridBagConstraints);
        ++gridBagConstraints.gridy;
        if (bl) {
            gridBagConstraints.insets.bottom = 5;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 17;
            String string = MessageFormat.format(this.messages.getString("DiskSpaceMBLabel"), this.getDiskSpaceMB());
            jPanel.add((Component)new JLabel(string), gridBagConstraints);
        }
        ++gridBagConstraints.gridy;
    }

    private String getDiskSpaceMB() {
        double d = (double)Installer.getInstance().getMinSize() / 1048576.0;
        NumberFormat numberFormat = NumberFormat.getInstance();
        numberFormat.setMinimumIntegerDigits(1);
        numberFormat.setMaximumFractionDigits(2);
        return numberFormat.format(d);
    }

    protected int getMaxGridWidth() {
        return 2;
    }

    protected String getTitle() {
        return this.messages.getString("WizardSelectDir");
    }

    protected String getSubTitle() {
        return MessageFormat.format(this.messages.getString("SelectDirDesc"), this.getApplicationName());
    }

    protected void setupControls() {
        super.setupControls();
        this.chooserWrapperPanel = new JPanel(new BorderLayout());
        new DirectoryChooser(new File("."), "", this, this);
    }

    protected boolean needsSpacer() {
        return false;
    }

    public boolean validateInternally(File file) {
        return Installer.validateInstallationDirectory(file, this.getDirectoryValidator(), this);
    }

    public DirectoryValidator getDirectoryValidator() {
        if (!this.directoryValidatorInitialized) {
            this.directoryValidatorInitialized = true;
            this.directoryValidator = Installer.getInstance().getDirectoryValidator();
        }
        return this.directoryValidator;
    }
}

