/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject.util;

import com.google.inject.spi.SourceProviders;
import com.google.inject.util.LineNumbers;
import com.google.inject.util.ReferenceCache;
import com.google.inject.util.ReferenceType;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Member;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StackTraceElements {
    static final Map<Class<?>, LineNumbers> lineNumbersCache = new ReferenceCache<Class<?>, LineNumbers>(ReferenceType.WEAK, ReferenceType.SOFT){

        @Override
        protected LineNumbers create(Class<?> key) {
            try {
                return new LineNumbers(key);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    };

    public static Object forMember(Member member) {
        if (member == null) {
            return SourceProviders.UNKNOWN_SOURCE;
        }
        Class<?> declaringClass = member.getDeclaringClass();
        LineNumbers lineNumbers = lineNumbersCache.get(declaringClass);
        Integer lineNumber = lineNumbers.getLineNumber(member);
        String memberName = member instanceof Constructor ? "<init>" : member.getName();
        StackTraceElement element = new StackTraceElement(declaringClass.getName(), memberName, lineNumbers.getSource(), lineNumber == null ? lineNumbers.getFirstLine() : lineNumber.intValue());
        return element;
    }

    public static Object forType(Class<?> implementation) {
        LineNumbers lineNumbers = lineNumbersCache.get(implementation);
        return new StackTraceElement(implementation.getName(), "class", lineNumbers.getSource(), lineNumbers.getFirstLine());
    }
}

