/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.stack;

import gov.nist.core.HostPort;
import gov.nist.javax.sip.stack.MessageChannel;
import gov.nist.javax.sip.stack.MessageProcessor;
import gov.nist.javax.sip.stack.SIPTransactionStack;
import gov.nist.javax.sip.stack.TLSMessageChannel;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import javax.net.ssl.SSLServerSocket;

public class TLSMessageProcessor
extends MessageProcessor {
    protected int nConnections;
    private boolean isRunning;
    private Hashtable tlsMessageChannels;
    private ServerSocket sock;
    protected int useCount = 0;
    protected SIPTransactionStack sipStack;
    private static final String[] CIPHERSUITES = new String[]{"TLS_RSA_WITH_AES_128_CBC_SHA", "SSL_RSA_WITH_3DES_EDE_CBC_SHA"};

    protected TLSMessageProcessor(InetAddress inetAddress, SIPTransactionStack sIPTransactionStack, int n) {
        super(inetAddress, n, "tls");
        this.sipStack = sIPTransactionStack;
        this.tlsMessageChannels = new Hashtable();
    }

    public void start() throws IOException {
        Thread thread = new Thread(this);
        thread.setName("TLSMessageProcessorThread");
        thread.setDaemon(true);
        if (!this.sipStack.useTlsAccelerator) {
            this.sock = this.sipStack.getNetworkLayer().createSSLServerSocket(this.getPort(), 0, this.getIpAddress());
            ((SSLServerSocket)this.sock).setNeedClientAuth(false);
            ((SSLServerSocket)this.sock).setUseClientMode(false);
            ((SSLServerSocket)this.sock).setWantClientAuth(true);
            ((SSLServerSocket)this.sock).setEnabledCipherSuites(CIPHERSUITES);
        } else {
            this.sock = this.sipStack.getNetworkLayer().createServerSocket(this.getPort(), 0, this.getIpAddress());
        }
        this.isRunning = true;
        thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (this.isRunning) {
            try {
                Object object = this;
                synchronized (object) {
                    while (this.sipStack.maxConnections != -1 && this.nConnections >= this.sipStack.maxConnections) {
                        try {
                            this.wait();
                            if (this.isRunning) continue;
                            return;
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                            break;
                        }
                    }
                    ++this.nConnections;
                }
                object = this.sock.accept();
                if (this.sipStack.logWriter.isLoggingEnabled()) {
                    this.sipStack.logWriter.logDebug("Accepting new connection!");
                }
                new TLSMessageChannel((Socket)object, this.sipStack, this);
            }
            catch (SocketException socketException) {
                this.isRunning = false;
            }
            catch (IOException iOException) {
                this.sipStack.logWriter.logError("Problem Accepting Connection", iOException);
            }
            catch (Exception exception) {
                this.sipStack.logWriter.logError("Unexpected Exception!", exception);
            }
        }
    }

    public SIPTransactionStack getSIPStack() {
        return this.sipStack;
    }

    public synchronized void stop() {
        if (!this.isRunning) {
            return;
        }
        this.isRunning = false;
        try {
            this.sock.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        Collection collection = this.tlsMessageChannels.values();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            TLSMessageChannel tLSMessageChannel = (TLSMessageChannel)iterator.next();
            tLSMessageChannel.close();
        }
        this.notify();
    }

    protected synchronized void remove(TLSMessageChannel tLSMessageChannel) {
        String string = tLSMessageChannel.getKey();
        if (this.sipStack.isLoggingEnabled()) {
            this.sipStack.logWriter.logDebug(Thread.currentThread() + " removing " + string);
        }
        if (this.tlsMessageChannels.get(string) == tLSMessageChannel) {
            this.tlsMessageChannels.remove(string);
        }
    }

    public synchronized MessageChannel createMessageChannel(HostPort hostPort) throws IOException {
        String string = MessageChannel.getKey(hostPort, "TLS");
        if (this.tlsMessageChannels.get(string) != null) {
            return (TLSMessageChannel)this.tlsMessageChannels.get(string);
        }
        TLSMessageChannel tLSMessageChannel = new TLSMessageChannel(hostPort.getInetAddress(), hostPort.getPort(), this.sipStack, this);
        this.tlsMessageChannels.put(string, tLSMessageChannel);
        tLSMessageChannel.isCached = true;
        if (this.sipStack.isLoggingEnabled()) {
            this.sipStack.logWriter.logDebug("key " + string);
            this.sipStack.logWriter.logDebug("Creating " + tLSMessageChannel);
        }
        return tLSMessageChannel;
    }

    protected synchronized void cacheMessageChannel(TLSMessageChannel tLSMessageChannel) {
        String string = tLSMessageChannel.getKey();
        TLSMessageChannel tLSMessageChannel2 = (TLSMessageChannel)this.tlsMessageChannels.get(string);
        if (tLSMessageChannel2 != null) {
            if (this.sipStack.isLoggingEnabled()) {
                this.sipStack.logWriter.logDebug("Closing " + string);
            }
            tLSMessageChannel2.close();
        }
        if (this.sipStack.isLoggingEnabled()) {
            this.sipStack.logWriter.logDebug("Caching " + string);
        }
        this.tlsMessageChannels.put(string, tLSMessageChannel);
    }

    public synchronized MessageChannel createMessageChannel(InetAddress inetAddress, int n) throws IOException {
        try {
            String string = MessageChannel.getKey(inetAddress, n, "TLS");
            if (this.tlsMessageChannels.get(string) != null) {
                return (TLSMessageChannel)this.tlsMessageChannels.get(string);
            }
            TLSMessageChannel tLSMessageChannel = new TLSMessageChannel(inetAddress, n, this.sipStack, this);
            this.tlsMessageChannels.put(string, tLSMessageChannel);
            tLSMessageChannel.isCached = true;
            if (this.sipStack.isLoggingEnabled()) {
                this.sipStack.getLogWriter().logDebug("key " + string);
                this.sipStack.getLogWriter().logDebug("Creating " + tLSMessageChannel);
            }
            return tLSMessageChannel;
        }
        catch (UnknownHostException unknownHostException) {
            throw new IOException(unknownHostException.getMessage());
        }
    }

    public int getMaximumMessageSize() {
        return Integer.MAX_VALUE;
    }

    public boolean inUse() {
        return this.useCount != 0;
    }

    public int getDefaultTargetPort() {
        return 5061;
    }

    public boolean isSecure() {
        return true;
    }
}

