/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.whack.container;

import java.io.File;
import java.io.IOException;
import org.jivesoftware.util.XMLProperties;
import org.jivesoftware.whack.ExternalComponentManager;
import org.jivesoftware.whack.container.ComponentFinder;
import org.mortbay.http.SunJsseListener;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.servlet.WebApplicationContext;
import org.mortbay.log.Factory;
import org.mortbay.log.LogImpl;
import org.mortbay.log.OutputStreamLogSink;
import org.mortbay.util.InetAddrPort;
import org.xmpp.component.ComponentManager;

public class ServerContainer {
    private static final ServerContainer instance = new ServerContainer();
    private Server jetty;
    private ExternalComponentManager manager;
    private ComponentFinder componentFinder;
    private boolean setupMode = true;
    private String homeDir;
    private XMLProperties properties;
    private int adminPort;
    private int adminSecurePort;
    private String xmppServerHost;
    private int xmppServerPort;

    public static void main(String[] args) {
        if (args.length < 2) {
            System.err.println("Usage ServerContainer <absolute path to home folder> <config filename>");
            return;
        }
        String homeDir = args[0];
        XMLProperties properties = null;
        try {
            properties = new XMLProperties(homeDir + "/conf/" + args[1]);
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
        instance.setHomeDirectory(homeDir);
        instance.setProperties(properties);
        instance.start();
    }

    public static ServerContainer getInstance() {
        return instance;
    }

    public String getHomeDirectory() {
        return this.homeDir;
    }

    void setHomeDirectory(String homeDir) {
        this.homeDir = homeDir;
    }

    public XMLProperties getProperties() {
        return this.properties;
    }

    void setProperties(XMLProperties properties) {
        this.properties = properties;
    }

    public void start() {
        try {
            System.setProperty("org.apache.commons.logging.LogFactory", "org.mortbay.log.Factory");
            File logDir = new File(this.homeDir, "logs");
            if (!logDir.exists()) {
                logDir.mkdirs();
            }
            File logFile = new File(logDir, "admin-console.log");
            OutputStreamLogSink logSink = new OutputStreamLogSink(logFile.toString());
            logSink.start();
            LogImpl log = (LogImpl)Factory.getFactory().getInstance("");
            log.setVerbose(-1);
            log.add(logSink);
            this.jetty = new Server();
            boolean plainStarted = false;
            String interfaceName = this.properties.getProperty("adminConsole.inteface");
            String port = this.properties.getProperty("adminConsole.port");
            this.adminPort = port == null ? 9090 : Integer.parseInt(port);
            InetAddrPort address = new InetAddrPort(interfaceName, this.adminPort);
            if (this.adminPort > 0) {
                this.jetty.addListener(address);
                plainStarted = true;
            }
            boolean secureStarted = false;
            try {
                String securePortProperty = this.properties.getProperty("adminConsole.securePort");
                int n = this.adminSecurePort = securePortProperty == null ? 9091 : Integer.parseInt(securePortProperty);
                if (this.adminSecurePort > 0) {
                    SunJsseListener listener = new SunJsseListener();
                    String keyStoreLocation = this.properties.getProperty("xmpp.socket.ssl.keystore");
                    keyStoreLocation = keyStoreLocation == null ? "resources" + File.separator + "security" + File.separator + "keystore" : keyStoreLocation;
                    keyStoreLocation = this.homeDir + File.separator + keyStoreLocation;
                    String keypass = this.properties.getProperty("xmpp.socket.ssl.keypass");
                    keypass = keypass == null ? "changeit" : keypass;
                    keypass = keypass.trim();
                    String trustStoreLocation = this.properties.getProperty("xmpp.socket.ssl.truststore");
                    trustStoreLocation = trustStoreLocation == null ? "resources" + File.separator + "security" + File.separator + "truststore" : trustStoreLocation;
                    trustStoreLocation = this.homeDir + File.separator + trustStoreLocation;
                    String trustpass = this.properties.getProperty("xmpp.socket.ssl.trustpass");
                    trustpass = trustpass == null ? "changeit" : trustpass;
                    trustpass = trustpass.trim();
                    listener.setKeystore(keyStoreLocation);
                    listener.setKeyPassword(keypass);
                    listener.setPassword(keypass);
                    listener.setHost(interfaceName);
                    listener.setPort(this.adminSecurePort);
                    this.jetty.addListener(listener);
                    secureStarted = true;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if ("true".equals(this.properties.getProperty("setup"))) {
                this.setupMode = false;
            }
            this.xmppServerHost = this.properties.getProperty("xmppServer.host");
            port = this.properties.getProperty("xmppServer.port");
            this.xmppServerPort = port == null ? 5222 : Integer.parseInt(port);
            this.manager = new ExternalComponentManager(this.xmppServerHost, this.xmppServerPort);
            if (this.properties.getProperty("xmppServer.defaultSecretKey") != null) {
                this.manager.setDefaultSecretKey(this.properties.getProperty("xmppServer.defaultSecretKey"));
            }
            WebApplicationContext webAppContext = this.jetty.addWebApplication("/", this.homeDir + File.separator + "webapp");
            webAppContext.setWelcomeFiles(new String[]{"index.jsp"});
            this.jetty.start();
            if (!plainStarted && !secureStarted) {
                this.manager.getLog().info("Warning: admin console not started due to configuration settings.");
                System.out.println("Warning: admin console not started due to configuration settings.");
            } else if (!plainStarted && secureStarted) {
                this.manager.getLog().info("Admin console listening at secure port: " + this.adminSecurePort);
                System.out.println("Admin console listening at secure port: " + this.adminSecurePort);
            } else if (!secureStarted && plainStarted) {
                this.manager.getLog().info("Admin console listening at port: " + this.adminPort);
                System.out.println("Admin console listening at port: " + this.adminPort);
            } else {
                String msg = "Admin console listening at:\n  port: " + this.adminPort + "\n" + "  secure port: " + this.adminSecurePort;
                this.manager.getLog().info(msg);
            }
            File componentDir = new File(this.homeDir, "components");
            this.componentFinder = new ComponentFinder(this, componentDir);
            this.componentFinder.start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean isSetupMode() {
        return this.setupMode;
    }

    public ComponentManager getManager() {
        return this.manager;
    }
}

