/*
 * Decompiled with CFR 0.152.
 */
package org.apache.taglibs.standard.lang.jpath.expression;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Locale;
import java.util.StringTokenizer;
import javax.servlet.jsp.PageContext;
import org.apache.taglibs.standard.lang.jpath.adapter.ConversionException;
import org.apache.taglibs.standard.lang.jpath.adapter.Convert;
import org.apache.taglibs.standard.lang.jpath.adapter.IterationContext;
import org.apache.taglibs.standard.lang.jpath.expression.EvaluationException;
import org.apache.taglibs.standard.lang.jpath.expression.Parser;
import org.apache.taglibs.standard.lang.jpath.expression.SimpleNode;

public class FormatNumberFunction
extends SimpleNode {
    public FormatNumberFunction(int id) {
        super(id);
    }

    public FormatNumberFunction(Parser p, int id) {
        super(p, id);
    }

    public String toNormalizedString() {
        String normalized = "";
        normalized = "format-number(" + this.jjtGetChild(0).toNormalizedString() + this.jjtGetChild(1).toNormalizedString() + "," + ")";
        return normalized;
    }

    public Object evaluate(PageContext pageContext, IterationContext icontext) throws EvaluationException {
        String formatted;
        try {
            NumberFormat form;
            Double arg = Convert.toDouble(this.jjtGetChild(0).evaluate(pageContext, icontext));
            String pattern = Convert.toString(this.jjtGetChild(1).evaluate(pageContext, icontext));
            if (this.jjtGetNumChildren() > 2) {
                String arg3 = Convert.toString(this.jjtGetChild(2).evaluate(pageContext, icontext));
                Locale locale = this.getLocale(arg3);
                form = NumberFormat.getInstance(locale);
            } else {
                form = NumberFormat.getInstance();
            }
            try {
                ((DecimalFormat)form).applyPattern(pattern);
                formatted = form.format(arg);
            }
            catch (IllegalArgumentException iae) {
                formatted = new String("NaN");
            }
        }
        catch (ConversionException ce) {
            throw new EvaluationException(this, ce.getMessage());
        }
        return formatted;
    }

    private Locale getLocale(String arg) {
        Locale result;
        StringTokenizer st = new StringTokenizer(arg, "_");
        String language = null;
        String country = null;
        String variant = null;
        if (st.hasMoreTokens()) {
            language = st.nextToken();
            if (st.hasMoreTokens()) {
                country = st.nextToken();
                if (st.hasMoreTokens()) {
                    variant = st.nextToken();
                    result = new Locale(language, country, variant);
                } else {
                    result = new Locale(language, country);
                }
            } else {
                result = new Locale(language, "");
            }
        } else {
            result = Locale.getDefault();
        }
        return result;
    }
}

