/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.ratelim;

import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.ratelim.ConnectionQueueMgr;
import net.kano.joscar.ratelim.QueueRunner;
import net.kano.joscar.snac.ClientSnacProcessor;
import net.kano.joscar.snac.SnacQueueManager;
import net.kano.joscar.snac.SnacRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RateLimitingQueueMgr
implements SnacQueueManager {
    private final Map<ClientSnacProcessor, ConnectionQueueMgr> connMgrs = new IdentityHashMap<ClientSnacProcessor, ConnectionQueueMgr>();
    private final QueueRunner runner = new QueueRunner();

    public final QueueRunner getRunner() {
        return this.runner;
    }

    public void stop() {
        this.runner.stopCurrentRun();
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.stop();
    }

    void sendSnac(ClientSnacProcessor clientSnacProcessor, SnacRequest snacRequest) {
        clientSnacProcessor.sendSnacImmediately(snacRequest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final List<ConnectionQueueMgr> getQueueMgrs() {
        Map<ClientSnacProcessor, ConnectionQueueMgr> map = this.connMgrs;
        synchronized (map) {
            return DefensiveTools.getUnmodifiableCopy(this.connMgrs.values());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ConnectionQueueMgr getQueueMgr(ClientSnacProcessor clientSnacProcessor) {
        DefensiveTools.checkNull(clientSnacProcessor, "processor");
        Map<ClientSnacProcessor, ConnectionQueueMgr> map = this.connMgrs;
        synchronized (map) {
            return this.connMgrs.get(clientSnacProcessor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void attached(ClientSnacProcessor clientSnacProcessor) {
        Map<ClientSnacProcessor, ConnectionQueueMgr> map = this.connMgrs;
        synchronized (map) {
            this.connMgrs.put(clientSnacProcessor, new ConnectionQueueMgr(this, clientSnacProcessor));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void detached(ClientSnacProcessor clientSnacProcessor) {
        ConnectionQueueMgr connectionQueueMgr;
        Map<ClientSnacProcessor, ConnectionQueueMgr> map = this.connMgrs;
        synchronized (map) {
            connectionQueueMgr = this.connMgrs.remove(clientSnacProcessor);
        }
        connectionQueueMgr.detach();
    }

    @Override
    public void queueSnac(ClientSnacProcessor clientSnacProcessor, SnacRequest snacRequest) {
        DefensiveTools.checkNull(snacRequest, "request");
        this.getQueueMgr(clientSnacProcessor).queueSnac(snacRequest);
    }

    @Override
    public void clearQueue(ClientSnacProcessor clientSnacProcessor) {
        this.getQueueMgr(clientSnacProcessor).clearQueue();
    }

    @Override
    public void pause(ClientSnacProcessor clientSnacProcessor) {
        this.getQueueMgr(clientSnacProcessor).pause();
    }

    @Override
    public void unpause(ClientSnacProcessor clientSnacProcessor) {
        this.getQueueMgr(clientSnacProcessor).unpause();
    }

    public String toString() {
        return "RateLimitingQueueMgr: connMgrs=" + this.connMgrs.keySet();
    }
}

