/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.logging;

import java.util.logging.Level;
import java.util.logging.LogRecord;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.logging.Logger;

public final class JavaLogger
implements Logger {
    private final java.util.logging.Logger logger;

    JavaLogger(java.util.logging.Logger logger) {
        DefensiveTools.checkNull(logger, "logger");
        this.logger = logger;
    }

    public void logException(String string, Throwable throwable) {
        this.log(Level.WARNING, string, throwable);
    }

    public void logWarning(String string) {
        this.log(Level.WARNING, string, null);
    }

    private void log(Level level, String string, Throwable throwable) {
        LogRecord logRecord = new LogRecord(level, string);
        StackTraceElement stackTraceElement = this.findLastRealStackFrame();
        if (stackTraceElement != null) {
            logRecord.setSourceClassName(stackTraceElement.getClassName());
            logRecord.setSourceMethodName(stackTraceElement.getMethodName());
        }
        if (throwable != null) {
            logRecord.setThrown(throwable);
        }
        this.logger.log(logRecord);
    }

    private StackTraceElement findLastRealStackFrame() {
        StackTraceElement stackTraceElement = null;
        for (StackTraceElement stackTraceElement2 : new Throwable().getStackTrace()) {
            if (stackTraceElement2.getClassName().equals(JavaLogger.class.getName())) continue;
            stackTraceElement = stackTraceElement2;
            break;
        }
        return stackTraceElement;
    }

    public void logFine(String string) {
        this.log(Level.FINE, string, null);
    }

    public void logFiner(String string) {
        this.log(Level.FINER, string, null);
    }

    public boolean logWarningEnabled() {
        return this.logger.isLoggable(Level.WARNING);
    }

    public boolean logFineEnabled() {
        return this.logger.isLoggable(Level.FINE);
    }

    public boolean logFinerEnabled() {
        return this.logger.isLoggable(Level.FINER);
    }
}

