/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.plugin.rest.service;

import javax.annotation.PostConstruct;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.jivesoftware.openfire.plugin.rest.controller.UserServiceController;
import org.jivesoftware.openfire.plugin.rest.entity.UserEntities;
import org.jivesoftware.openfire.plugin.rest.entity.UserEntity;
import org.jivesoftware.openfire.plugin.rest.exceptions.ServiceException;

@Path(value="restapi/v1/users")
public class UserService {
    private UserServiceController plugin;

    @PostConstruct
    public void init() {
        this.plugin = UserServiceController.getInstance();
    }

    @GET
    @Produces(value={"application/xml", "application/json"})
    public UserEntities getUsers(@QueryParam(value="search") String userSearch, @QueryParam(value="propertyKey") String propertyKey, @QueryParam(value="propertyValue") String propertyValue) throws ServiceException {
        return this.plugin.getUserEntities(userSearch, propertyKey, propertyValue);
    }

    @POST
    public Response createUser(UserEntity userEntity) throws ServiceException {
        this.plugin.createUser(userEntity);
        return Response.status((Response.Status)Response.Status.CREATED).build();
    }

    @GET
    @Path(value="/{username}")
    @Produces(value={"application/xml", "application/json"})
    public UserEntity getUser(@PathParam(value="username") String username) throws ServiceException {
        return this.plugin.getUserEntity(username);
    }

    @PUT
    @Path(value="/{username}")
    public Response updateUser(@PathParam(value="username") String username, UserEntity userEntity) throws ServiceException {
        this.plugin.updateUser(username, userEntity);
        return Response.status((Response.Status)Response.Status.OK).build();
    }

    @DELETE
    @Path(value="/{username}")
    public Response deleteUser(@PathParam(value="username") String username) throws ServiceException {
        this.plugin.deleteUser(username);
        return Response.status((Response.Status)Response.Status.OK).build();
    }
}

