/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.nio;

import com.hazelcast.impl.base.CallStateAware;
import com.hazelcast.impl.base.SystemArgsLog;
import com.hazelcast.nio.AbstractSelectionHandler;
import com.hazelcast.nio.Connection;
import com.hazelcast.nio.Packet;
import com.hazelcast.nio.SocketPacketWriter;
import com.hazelcast.nio.SocketWritable;
import com.hazelcast.nio.SocketWriter;
import com.hazelcast.nio.ascii.SocketTextWriter;
import com.hazelcast.util.Clock;
import java.nio.ByteBuffer;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;

public final class WriteHandler
extends AbstractSelectionHandler
implements Runnable {
    private final Queue<SocketWritable> writeQueue = new ConcurrentLinkedQueue<SocketWritable>(){
        final AtomicInteger size = new AtomicInteger();

        @Override
        public boolean offer(SocketWritable socketWritable) {
            if (super.offer(socketWritable)) {
                this.size.incrementAndGet();
                return true;
            }
            return false;
        }

        @Override
        public SocketWritable poll() {
            SocketWritable socketWritable = (SocketWritable)super.poll();
            if (socketWritable != null) {
                this.size.decrementAndGet();
            }
            return socketWritable;
        }

        @Override
        public int size() {
            return this.size.get();
        }
    };
    private final AtomicBoolean informSelector = new AtomicBoolean(true);
    private final ByteBuffer socketBB;
    private boolean ready = false;
    private volatile SocketWritable lastWritable = null;
    private volatile SocketWriter socketWriter = null;
    volatile long lastRegistration = 0L;
    volatile long lastHandle = 0L;

    WriteHandler(Connection connection) {
        super(connection, connection.getInOutSelector());
        this.socketBB = ByteBuffer.allocate(this.connectionManager.SOCKET_SEND_BUFFER_SIZE);
    }

    public void setProtocol(String protocol) {
        if (this.socketWriter == null) {
            if ("HZC".equals(protocol)) {
                this.socketWriter = new SocketPacketWriter(this.connection);
                this.socketBB.put("HZC".getBytes());
                this.inOutSelector.addTask(this);
            } else {
                this.socketWriter = new SocketTextWriter(this.connection);
            }
        }
    }

    public SocketWriter getSocketWriter() {
        return this.socketWriter;
    }

    public void enqueueSocketWritable(SocketWritable socketWritable) {
        socketWritable.onEnqueue();
        this.writeQueue.offer(socketWritable);
        if (this.informSelector.compareAndSet(true, false)) {
            this.inOutSelector.addTask(this);
            this.inOutSelector.selector.wakeup();
        }
    }

    SocketWritable poll() {
        return this.writeQueue.poll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle() {
        block19: {
            this.lastHandle = Clock.currentTimeMillis();
            if (this.socketWriter == null) {
                this.setProtocol("HZC");
            }
            if (this.lastWritable == null) {
                this.lastWritable = this.poll();
                if (this.lastWritable == null && this.socketBB.position() == 0) {
                    this.ready = true;
                    return;
                }
            }
            if (!this.connection.live()) {
                return;
            }
            try {
                while (this.socketBB.hasRemaining()) {
                    if (this.lastWritable == null) {
                        this.lastWritable = this.poll();
                    }
                    if (this.lastWritable == null) break;
                    boolean complete = this.socketWriter.write(this.lastWritable, this.socketBB);
                    if (complete) {
                        if (this.lastWritable instanceof Packet) {
                            Packet packet = (Packet)this.lastWritable;
                            this.connection.releasePacket(packet);
                            if (this.systemLogService.shouldTrace()) {
                                this.systemLogService.trace((CallStateAware)packet, new SystemArgsLog("WrittenOut ", this.connection.getEndPoint(), (Object)packet.operation));
                            }
                        }
                        this.lastWritable = null;
                        continue;
                    }
                    if (!this.socketBB.hasRemaining()) continue;
                    break;
                }
                if (this.socketBB.position() <= 0) break block19;
                this.socketBB.flip();
                try {
                    this.socketChannel.write(this.socketBB);
                }
                catch (Exception e) {
                    this.lastWritable = null;
                    this.handleSocketException(e);
                    this.ready = false;
                    this.registerWrite();
                    return;
                }
                if (this.socketBB.hasRemaining()) {
                    this.socketBB.compact();
                } else {
                    this.socketBB.clear();
                }
            }
            catch (Throwable t) {
                this.logger.log(Level.SEVERE, "Fatal Error at WriteHandler for endPoint: " + this.connection.getEndPoint(), t);
                this.connection.getSystemLogService().logConnection("Fatal Error at WriteHandler for endPoint [" + this.connection.getEndPoint() + "]: " + t.getMessage());
            }
            finally {
                this.ready = false;
                this.registerWrite();
            }
        }
    }

    public void run() {
        this.informSelector.set(true);
        if (this.ready) {
            this.handle();
        } else {
            this.registerWrite();
        }
        this.ready = false;
    }

    private void registerWrite() {
        this.lastRegistration = Clock.currentTimeMillis();
        this.registerOp(this.inOutSelector.selector, 4);
    }

    public void shutdown() {
        SocketWritable obj = this.poll();
        while (obj != null) {
            obj = this.poll();
        }
    }

    public int size() {
        return this.writeQueue.size();
    }
}

