/*
 * Decompiled with CFR 0.152.
 */
package com.voxeo.spring.properties;

import com.voxeo.spring.properties.ReconfigurableBean;
import com.voxeo.spring.properties.ReloadablePropertiesBase;
import com.voxeo.spring.properties.ReloadablePropertiesListener;
import com.voxeo.utils.Files;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.Lock;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.config.PropertiesFactoryBean;
import org.springframework.core.io.Resource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReloadablePropertiesFactoryBean
extends PropertiesFactoryBean
implements DisposableBean {
    private Logger log = Logger.getLogger(((Object)((Object)this)).getClass());
    private boolean lockFile;
    private Resource[] locations;
    private long[] lastModified;
    private List<ReloadablePropertiesListener> preListeners;
    private ReloadablePropertiesBase reloadableProperties;

    public void setLocation(Resource location) {
        this.setLocations(new Resource[]{location});
    }

    public void setLocations(Resource[] locations) {
        this.locations = locations;
        this.lastModified = new long[locations.length];
        super.setLocations(locations);
    }

    protected Resource[] getLocations() {
        return this.locations;
    }

    public void setListeners(List<ReloadablePropertiesListener> listeners) {
        this.preListeners = new ArrayList<ReloadablePropertiesListener>();
        this.preListeners.addAll(listeners);
    }

    protected Object createInstance() throws IOException {
        if (!this.isSingleton()) {
            throw new RuntimeException("ReloadablePropertiesFactoryBean only works as singleton");
        }
        this.reloadableProperties = new ReloadablePropertiesImpl();
        if (this.preListeners != null) {
            this.reloadableProperties.setListeners(this.preListeners);
        }
        this.reload(true);
        return this.reloadableProperties;
    }

    public void destroy() throws Exception {
        this.reloadableProperties = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void reload(boolean forceReload) throws IOException {
        boolean reload = forceReload;
        for (int i = 0; i < this.locations.length; ++i) {
            File file;
            Resource location = this.locations[i];
            try {
                file = location.getFile();
            }
            catch (IOException e) {
                continue;
            }
            try {
                long l = file.lastModified();
                if (l == this.lastModified[i]) continue;
                this.lastModified[i] = l;
                reload = true;
                continue;
            }
            catch (Exception e) {
                if (!this.log.isDebugEnabled()) continue;
                this.log.debug((Object)("can't determine modification time of " + file + " for " + location), (Throwable)e);
            }
        }
        if (reload) {
            if (this.locations.length == 1 && this.lockFile) {
                Lock lock = Files.readLock(this.locations[0].getFile());
                try {
                    lock.lock();
                    this.doReload();
                }
                finally {
                    lock.unlock();
                }
            } else {
                this.doReload();
            }
        }
    }

    public boolean isLockFile() {
        return this.lockFile;
    }

    public void setLockFile(boolean lockFile) {
        this.lockFile = lockFile;
    }

    private void doReload() throws IOException {
        this.reloadableProperties.setProperties(this.mergeProperties());
    }

    class ReloadablePropertiesImpl
    extends ReloadablePropertiesBase
    implements ReconfigurableBean {
        private static final long serialVersionUID = -4287984893630951847L;

        ReloadablePropertiesImpl() {
        }

        public void reloadConfiguration() throws Exception {
            ReloadablePropertiesFactoryBean.this.reload(false);
        }
    }
}

