/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.parser;

import gov.nist.core.LexerCore;
import java.util.concurrent.ConcurrentHashMap;

public class Lexer
extends LexerCore {
    public static String getHeaderName(String line) {
        if (line == null) {
            return null;
        }
        String headerName = null;
        try {
            int begin = line.indexOf(":");
            headerName = null;
            if (begin >= 1) {
                headerName = line.substring(0, begin).trim();
            }
        }
        catch (IndexOutOfBoundsException e) {
            return null;
        }
        return headerName;
    }

    public Lexer(String lexerName, String buffer) {
        super(lexerName, buffer);
        this.selectLexer(lexerName);
    }

    public static String getHeaderValue(String line) {
        if (line == null) {
            return null;
        }
        String headerValue = null;
        try {
            int begin = line.indexOf(":");
            headerValue = line.substring(begin + 1);
        }
        catch (IndexOutOfBoundsException e) {
            return null;
        }
        return headerValue;
    }

    public void selectLexer(String lexerName) {
        ConcurrentHashMap lexer = (ConcurrentHashMap)lexerTables.get(lexerName);
        this.currentLexerName = lexerName;
        if (lexer == null) {
            ConcurrentHashMap newLexer = new ConcurrentHashMap();
            lexer = lexerTables.putIfAbsent(lexerName, newLexer);
            if (lexer == null) {
                lexer = newLexer;
            }
            this.currentLexer = lexer;
            if (lexerName.equals("method_keywordLexer")) {
                this.addKeyword("REGISTER", 2052);
                this.addKeyword("ACK", 2054);
                this.addKeyword("OPTIONS", 2056);
                this.addKeyword("BYE", 2055);
                this.addKeyword("INVITE", 2053);
                this.addKeyword("sip", 2051);
                this.addKeyword("sips", 2136);
                this.addKeyword("SUBSCRIBE", 2101);
                this.addKeyword("NOTIFY", 2102);
                this.addKeyword("MESSAGE", 2118);
                this.addKeyword("PUBLISH", 2115);
            } else if (lexerName.equals("command_keywordLexer")) {
                this.addKeyword("Error-Info", 2058);
                this.addKeyword("Allow-Events", 2113);
                this.addKeyword("Authentication-Info", 2112);
                this.addKeyword("Event", 2111);
                this.addKeyword("Min-Expires", 2110);
                this.addKeyword("RSeq", 2108);
                this.addKeyword("RAck", 2109);
                this.addKeyword("Reason", 2107);
                this.addKeyword("Reply-To", 2106);
                this.addKeyword("Subscription-State", 2104);
                this.addKeyword("Timestamp", 2103);
                this.addKeyword("In-Reply-To", 2059);
                this.addKeyword("MIME-Version", 2060);
                this.addKeyword("Alert-Info", 2061);
                this.addKeyword("From", 2062);
                this.addKeyword("To", 2063);
                this.addKeyword("Refer-To", 2114);
                this.addKeyword("Via", 2064);
                this.addKeyword("User-Agent", 2065);
                this.addKeyword("Server", 2066);
                this.addKeyword("Accept-Encoding", 2067);
                this.addKeyword("Accept", 2068);
                this.addKeyword("Allow", 2069);
                this.addKeyword("Route", 2070);
                this.addKeyword("Authorization", 2071);
                this.addKeyword("Proxy-Authorization", 2072);
                this.addKeyword("Retry-After", 2073);
                this.addKeyword("Proxy-Require", 2074);
                this.addKeyword("Content-Language", 2075);
                this.addKeyword("Unsupported", 2076);
                this.addKeyword("Supported", 2068);
                this.addKeyword("Warning", 2078);
                this.addKeyword("Max-Forwards", 2079);
                this.addKeyword("Date", 2080);
                this.addKeyword("Priority", 2081);
                this.addKeyword("Proxy-Authenticate", 2082);
                this.addKeyword("Content-Encoding", 2083);
                this.addKeyword("Content-Length", 2084);
                this.addKeyword("Subject", 2085);
                this.addKeyword("Content-Type", 2086);
                this.addKeyword("Contact", 2087);
                this.addKeyword("Call-ID", 2088);
                this.addKeyword("Require", 2089);
                this.addKeyword("Expires", 2090);
                this.addKeyword("Record-Route", 2092);
                this.addKeyword("Organization", 2093);
                this.addKeyword("CSeq", 2094);
                this.addKeyword("Accept-Language", 2095);
                this.addKeyword("WWW-Authenticate", 2096);
                this.addKeyword("Call-Info", 2099);
                this.addKeyword("Content-Disposition", 2100);
                this.addKeyword("K", 2068);
                this.addKeyword("C", 2086);
                this.addKeyword("E", 2083);
                this.addKeyword("F", 2062);
                this.addKeyword("I", 2088);
                this.addKeyword("M", 2087);
                this.addKeyword("L", 2084);
                this.addKeyword("S", 2085);
                this.addKeyword("T", 2063);
                this.addKeyword("U", 2113);
                this.addKeyword("V", 2064);
                this.addKeyword("R", 2114);
                this.addKeyword("O", 2111);
                this.addKeyword("X", 2133);
                this.addKeyword("SIP-ETag", 2116);
                this.addKeyword("SIP-If-Match", 2117);
                this.addKeyword("Session-Expires", 2133);
                this.addKeyword("Min-SE", 2134);
                this.addKeyword("Referred-By", 2132);
                this.addKeyword("Replaces", 2135);
                this.addKeyword("Join", 2140);
                this.addKeyword("Path", 2119);
                this.addKeyword("Service-Route", 2120);
                this.addKeyword("P-Asserted-Identity", 2121);
                this.addKeyword("P-Preferred-Identity", 2122);
                this.addKeyword("Privacy", 2126);
                this.addKeyword("P-Called-Party-ID", 2128);
                this.addKeyword("P-Associated-URI", 2129);
                this.addKeyword("P-Visited-Network-ID", 2123);
                this.addKeyword("P-Charging-Function-Addresses", 2124);
                this.addKeyword("P-Charging-Vector", 2125);
                this.addKeyword("P-Access-Network-Info", 2127);
                this.addKeyword("P-Media-Authorization", 2130);
                this.addKeyword("Security-Server", 2137);
                this.addKeyword("Security-Verify", 2139);
                this.addKeyword("Security-Client", 2138);
                this.addKeyword("P-User-Database", 2141);
                this.addKeyword("P-Profile-Key", 2142);
                this.addKeyword("P-Served-User", 2143);
                this.addKeyword("P-Preferred-Service", 2144);
                this.addKeyword("P-Asserted-Service", 2145);
                this.addKeyword("References", 2146);
            } else if (lexerName.equals("status_lineLexer")) {
                this.addKeyword("sip", 2051);
            } else if (lexerName.equals("request_lineLexer")) {
                this.addKeyword("sip", 2051);
            } else if (lexerName.equals("sip_urlLexer")) {
                this.addKeyword("tel", 2105);
                this.addKeyword("sip", 2051);
                this.addKeyword("sips", 2136);
            }
        } else {
            this.currentLexer = lexer;
        }
    }
}

