/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.header;

import gov.nist.javax.sip.header.SIPHeader;
import javax.sip.InvalidArgumentException;
import javax.sip.header.MaxForwardsHeader;
import javax.sip.header.TooManyHopsException;

public class MaxForwards
extends SIPHeader
implements MaxForwardsHeader {
    private static final long serialVersionUID = -3096874323347175943L;
    protected int maxForwards;

    public MaxForwards() {
        super("Max-Forwards");
    }

    public MaxForwards(int n) throws InvalidArgumentException {
        super("Max-Forwards");
        this.setMaxForwards(n);
    }

    public int getMaxForwards() {
        return this.maxForwards;
    }

    public void setMaxForwards(int n) throws InvalidArgumentException {
        if (n < 0 || n > 255) {
            throw new InvalidArgumentException("bad max forwards value " + n);
        }
        this.maxForwards = n;
    }

    public String encodeBody() {
        return this.encodeBody(new StringBuffer()).toString();
    }

    protected StringBuffer encodeBody(StringBuffer stringBuffer) {
        return stringBuffer.append(this.maxForwards);
    }

    public boolean hasReachedZero() {
        return this.maxForwards == 0;
    }

    public void decrementMaxForwards() throws TooManyHopsException {
        if (this.maxForwards > 0) {
            --this.maxForwards;
        } else {
            throw new TooManyHopsException("has already reached 0!");
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof MaxForwardsHeader) {
            MaxForwardsHeader maxForwardsHeader = (MaxForwardsHeader)object;
            return this.getMaxForwards() == maxForwardsHeader.getMaxForwards();
        }
        return false;
    }
}

