/*
 * Decompiled with CFR 0.152.
 */
package pl.mn.communicator.packet.in;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import pl.mn.communicator.IRemoteStatus;
import pl.mn.communicator.IUser;
import pl.mn.communicator.RemoteStatus;
import pl.mn.communicator.User;
import pl.mn.communicator.packet.GGConversion;
import pl.mn.communicator.packet.GGStatuses;
import pl.mn.communicator.packet.GGUtils;
import pl.mn.communicator.packet.in.GGIncomingPackage;

public class GGStatus60
implements GGIncomingPackage,
GGStatuses {
    public static final int GG_STATUS60 = 15;
    private static final Log LOGGER = LogFactory.getLog((Class)GGStatus60.class);
    private IUser m_user = null;
    private RemoteStatus m_status60 = null;

    public GGStatus60(byte[] data) {
        this.handleUser(data);
        this.handleStatus60(data);
    }

    public int getPacketType() {
        return 15;
    }

    public IUser getUser() {
        return this.m_user;
    }

    public IRemoteStatus getStatus60() {
        return this.m_status60;
    }

    private void handleUser(byte[] data) {
        byte flag = data[3];
        data[3] = GGUtils.intToByte(0)[0];
        int uin = GGUtils.byteToInt(data);
        data[3] = flag;
        int protocolStatus = GGUtils.unsignedByteToInt(data[4]);
        User.UserMode userMode = GGConversion.getUserMode(protocolStatus);
        this.m_user = new User(uin, userMode);
    }

    private void handleStatus60(byte[] data) {
        byte flag = data[3];
        int protocolStatus = GGUtils.unsignedByteToInt(data[4]);
        int remoteIP = GGUtils.byteToInt(data, 5);
        byte[] remoteIPArray = GGUtils.convertIntToByteArray(remoteIP);
        int remotePort = GGUtils.byteToShort(data, 9);
        int version = GGUtils.unsignedByteToInt(data[11]);
        int imageSize = GGUtils.unsignedByteToInt(data[12]);
        String description = null;
        long timeInMillis = -1L;
        if ((protocolStatus == 4 || protocolStatus == 5 || protocolStatus == 22 || protocolStatus == 21) && data.length > 14 + (description = GGUtils.bytezToString(data, 14)).length()) {
            int timeInSeconds = GGUtils.byteToInt(data, data.length - 4);
            timeInMillis = GGUtils.secondsToMillis(timeInSeconds);
        }
        this.m_status60 = GGConversion.getClientRemoteStatus(protocolStatus, description, timeInMillis);
        this.m_status60.setRemoteIP(remoteIPArray);
        this.m_status60.setImageSize(imageSize);
        this.m_status60.setGGVersion(version);
        if (remotePort == 0) {
            this.m_status60.setSupportsDirectCommunication(false);
        } else if (remotePort == 1) {
            this.m_status60.setUserBehindFirewall(true);
        } else if (remotePort == 2) {
            this.m_status60.setAreWeInRemoteUserBuddyList(false);
        } else {
            this.m_status60.setRemotePort(remotePort);
        }
        if (flag == 64) {
            this.m_status60.setSupportsVoiceCommunication(true);
        }
    }
}

