/*
 * Decompiled with CFR 0.152.
 */
package socks;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Hashtable;
import socks.Authentication;
import socks.AuthenticationNone;
import socks.InetRange;
import socks.Proxy;
import socks.ProxyMessage;
import socks.Socks5Message;
import socks.SocksException;
import socks.UDPEncapsulation;

public class Socks5Proxy
extends Proxy
implements Cloneable {
    private Hashtable authMethods = new Hashtable();
    private int selectedMethod;
    boolean resolveAddrLocally = true;
    UDPEncapsulation udp_encapsulation = null;

    public Socks5Proxy(Proxy p, String proxyHost, int proxyPort) throws UnknownHostException {
        super(p, proxyHost, proxyPort);
        this.version = 5;
        this.setAuthenticationMethod(0, new AuthenticationNone());
    }

    public Socks5Proxy(String proxyHost, int proxyPort) throws UnknownHostException {
        this(null, proxyHost, proxyPort);
    }

    public Socks5Proxy(Proxy p, InetAddress proxyIP, int proxyPort) {
        super(p, proxyIP, proxyPort);
        this.version = 5;
        this.setAuthenticationMethod(0, new AuthenticationNone());
    }

    public Socks5Proxy(InetAddress proxyIP, int proxyPort) {
        this(null, proxyIP, proxyPort);
    }

    public boolean resolveAddrLocally(boolean doResolve) {
        boolean old = this.resolveAddrLocally;
        this.resolveAddrLocally = doResolve;
        return old;
    }

    public boolean resolveAddrLocally() {
        return this.resolveAddrLocally;
    }

    public boolean setAuthenticationMethod(int methodId, Authentication method) {
        if (methodId < 0 || methodId > 255) {
            return false;
        }
        if (method == null) {
            return this.authMethods.remove(new Integer(methodId)) != null;
        }
        this.authMethods.put(new Integer(methodId), method);
        return true;
    }

    public Authentication getAuthenticationMethod(int methodId) {
        Object method = this.authMethods.get(new Integer(methodId));
        if (method == null) {
            return null;
        }
        return (Authentication)method;
    }

    public Object clone() {
        Socks5Proxy newProxy = new Socks5Proxy(this.proxyIP, this.proxyPort);
        newProxy.authMethods = (Hashtable)this.authMethods.clone();
        newProxy.directHosts = (InetRange)this.directHosts.clone();
        newProxy.resolveAddrLocally = this.resolveAddrLocally;
        newProxy.chainProxy = this.chainProxy;
        return newProxy;
    }

    protected Proxy copy() {
        Socks5Proxy copy = new Socks5Proxy(this.proxyIP, this.proxyPort);
        copy.authMethods = this.authMethods;
        copy.directHosts = this.directHosts;
        copy.chainProxy = this.chainProxy;
        copy.resolveAddrLocally = this.resolveAddrLocally;
        return copy;
    }

    protected void startSession() throws SocksException {
        super.startSession();
        Socket ps = this.proxySocket;
        try {
            byte nMethods = (byte)this.authMethods.size();
            byte[] buf = new byte[2 + nMethods];
            buf[0] = (byte)this.version;
            buf[1] = nMethods;
            int i = 2;
            Enumeration ids = this.authMethods.keys();
            while (ids.hasMoreElements()) {
                buf[i++] = (byte)((Integer)ids.nextElement()).intValue();
            }
            this.out.write(buf);
            this.out.flush();
            int versionNumber = this.in.read();
            this.selectedMethod = this.in.read();
            if (versionNumber < 0 || this.selectedMethod < 0) {
                this.endSession();
                throw new SocksException(196608, "Connection to proxy lost.");
            }
            if (versionNumber < this.version) {
                // empty if block
            }
            if (this.selectedMethod == 255) {
                ps.close();
                throw new SocksException(262144);
            }
            Authentication auth = this.getAuthenticationMethod(this.selectedMethod);
            if (auth == null) {
                throw new SocksException(393216, "Specified Authentication not found!");
            }
            Object[] in_out = auth.doSocksAuthentication(this.selectedMethod, ps);
            if (in_out == null) {
                throw new SocksException(327680);
            }
            this.in = (InputStream)in_out[0];
            this.out = (OutputStream)in_out[1];
            if (in_out.length > 2) {
                this.udp_encapsulation = (UDPEncapsulation)in_out[2];
            }
        }
        catch (SocksException s_ex) {
            throw s_ex;
        }
        catch (UnknownHostException uh_ex) {
            throw new SocksException(131072);
        }
        catch (SocketException so_ex) {
            throw new SocksException(131072);
        }
        catch (IOException io_ex) {
            throw new SocksException(196608, (Throwable)io_ex);
        }
    }

    protected ProxyMessage formMessage(int cmd, InetAddress ip, int port) {
        return new Socks5Message(cmd, ip, port);
    }

    protected ProxyMessage formMessage(int cmd, String host, int port) throws UnknownHostException {
        if (this.resolveAddrLocally) {
            return this.formMessage(cmd, InetAddress.getByName(host), port);
        }
        return new Socks5Message(cmd, host, port);
    }

    protected ProxyMessage formMessage(InputStream in) throws SocksException, IOException {
        return new Socks5Message(in);
    }
}

