/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jml.util;

import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import net.sf.jml.util.NumberUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DigestUtils {
    private static final Log log = LogFactory.getLog(DigestUtils.class);

    public static byte[] md5(byte[] byArray) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            return messageDigest.digest(byArray);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            log.error((Object)noSuchAlgorithmException, (Throwable)noSuchAlgorithmException);
            return null;
        }
    }

    public static String md5(String string) {
        byte[] byArray = DigestUtils.md5(string.getBytes());
        return NumberUtils.toHexValue(ByteBuffer.wrap(byArray));
    }

    public static byte[] sha1(byte[] byArray) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-1");
            return messageDigest.digest(byArray);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            log.error((Object)noSuchAlgorithmException, (Throwable)noSuchAlgorithmException);
            return null;
        }
    }

    public static byte[] sha1(ByteBuffer[] byteBufferArray) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-1");
            for (ByteBuffer byteBuffer : byteBufferArray) {
                DigestUtils.update(messageDigest, byteBuffer.slice());
            }
            return messageDigest.digest();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            log.error((Object)noSuchAlgorithmException, (Throwable)noSuchAlgorithmException);
            return null;
        }
    }

    private static void update(MessageDigest messageDigest, ByteBuffer byteBuffer) {
        if (byteBuffer.hasArray()) {
            messageDigest.update(byteBuffer.array(), byteBuffer.arrayOffset() + byteBuffer.position(), byteBuffer.remaining());
        } else {
            byte[] byArray = new byte[byteBuffer.remaining()];
            byteBuffer.get(byArray);
            messageDigest.update(byArray);
        }
    }
}

