/*
 * Decompiled with CFR 0.152.
 */
package org.openymsg.network.event;

import org.openymsg.network.event.SessionEvent;

public class SessionNotifyEvent
extends SessionEvent {
    protected String type;
    protected boolean mode;

    public static SessionNotifyEvent createSessionNotifyEvent(Object source, String to, String from, String message, String type, String mode) {
        boolean m;
        if ("0".equals(mode)) {
            m = false;
        } else if ("1".equals(mode)) {
            m = true;
        } else {
            throw new IllegalArgumentException("A mode of '0' or '1' is expected. The provide mode was: " + mode);
        }
        return new SessionNotifyEvent(source, to, from, message, type, m);
    }

    public SessionNotifyEvent(Object source, String to, String from, String message, String type, boolean mode) {
        super(source, to, from, message);
        this.type = type;
        this.mode = mode;
    }

    public boolean getMode() {
        return this.mode;
    }

    public boolean isOn() {
        return this.mode;
    }

    public boolean isOff() {
        return !this.mode;
    }

    public String getType() {
        return this.type;
    }

    public String getGame() {
        if (!this.isGame()) {
            throw new IllegalStateException("This is not a gaming-typed notification.");
        }
        return this.getMessage();
    }

    public boolean isTyping() {
        return this.type != null && this.type.equalsIgnoreCase("TYPING");
    }

    public boolean isGame() {
        return this.type != null && this.type.equalsIgnoreCase("GAME");
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(super.toString()).append(" type:").append(this.type).append(" mode:").append(this.mode ? "1" : "0");
        return sb.toString();
    }
}

