/*
 * Decompiled with CFR 0.152.
 */
package pl.mn.communicator.packet;

public class HexDump {
    public static String byteToHexString(byte b) {
        return HexDump.intToHexString(b, 2, '0');
    }

    public static String intToHexString(int num, int width, char fill) {
        String result = "";
        if (num == 0) {
            result = "0";
            --width;
        } else {
            while (num != 0 && width > 0) {
                String tmp = Integer.toHexString(num & 0xF);
                result = tmp + result;
                num >>= 4;
                --width;
            }
        }
        while (width > 0) {
            result = fill + result;
            --width;
        }
        return result;
    }

    public static String hexDump(byte[] data) {
        return HexDump.hexDump(data, data.length);
    }

    public static String hexDump(byte[] data, int length) {
        int bytesPerLine = 16;
        String result = "";
        for (int i = 0; i < length; i += 16) {
            int j;
            result = result + HexDump.intToHexString(i, 4, '0') + "  ";
            for (j = i; j < length && j - i < 16; ++j) {
                result = result + HexDump.byteToHexString(data[j]) + " ";
            }
            while (0 != j % 16) {
                result = result + "   ";
                ++j;
            }
            result = result + "  |";
            for (j = i; j < length && j - i < 16; ++j) {
                if ((data[j] & 0xFF) > 31 && (data[j] & 0xFF) < 127) {
                    Character ch = new Character((char)data[j]);
                    result = result + ch;
                    continue;
                }
                result = result + ".";
            }
            result = result + "|";
        }
        return result;
    }
}

