/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.header;

import gov.nist.core.NameValue;
import gov.nist.core.NameValueList;
import gov.nist.javax.sip.address.GenericURI;
import gov.nist.javax.sip.header.SIPHeader;
import java.text.ParseException;
import java.util.Iterator;
import javax.sip.header.Parameters;

public abstract class ParametersHeader
extends SIPHeader
implements Parameters {
    protected NameValueList parameters;

    protected ParametersHeader() {
        this.parameters = new NameValueList();
    }

    protected ParametersHeader(String string) {
        super(string);
        this.parameters = new NameValueList();
    }

    protected ParametersHeader(String string, boolean bl) {
        super(string);
        this.parameters = new NameValueList(bl);
    }

    public String getParameter(String string) {
        return this.parameters.getParameter(string);
    }

    public Object getParameterValue(String string) {
        return this.parameters.getValue(string);
    }

    public Iterator getParameterNames() {
        return this.parameters.getNames();
    }

    public boolean hasParameters() {
        return this.parameters != null && !this.parameters.isEmpty();
    }

    public void removeParameter(String string) {
        this.parameters.delete(string);
    }

    public void setParameter(String string, String string2) throws ParseException {
        NameValue nameValue = this.parameters.getNameValue(string);
        if (nameValue != null) {
            nameValue.setValue(string2);
        } else {
            nameValue = new NameValue(string, string2);
            this.parameters.set(nameValue);
        }
    }

    public void setQuotedParameter(String string, String string2) throws ParseException {
        NameValue nameValue = this.parameters.getNameValue(string);
        if (nameValue != null) {
            nameValue.setValue(string2);
            nameValue.setQuotedValue();
        } else {
            nameValue = new NameValue(string, string2);
            nameValue.setQuotedValue();
            this.parameters.set(nameValue);
        }
    }

    protected void setParameter(String string, int n) {
        Integer n2 = new Integer(n);
        this.parameters.set(string, n2);
    }

    protected void setParameter(String string, boolean bl) {
        Boolean bl2 = new Boolean(bl);
        this.parameters.set(string, bl2);
    }

    protected void setParameter(String string, float f) {
        Float f2 = new Float(f);
        NameValue nameValue = this.parameters.getNameValue(string);
        if (nameValue != null) {
            nameValue.setValue(f2);
        } else {
            nameValue = new NameValue(string, f2);
            this.parameters.set(nameValue);
        }
    }

    protected void setParameter(String string, Object object) {
        this.parameters.set(string, object);
    }

    public boolean hasParameter(String string) {
        return this.parameters.hasNameValue(string);
    }

    public void removeParameters() {
        this.parameters = new NameValueList();
    }

    public NameValueList getParameters() {
        return this.parameters;
    }

    public void setParameter(NameValue nameValue) {
        this.parameters.set(nameValue);
    }

    public void setParameters(NameValueList nameValueList) {
        this.parameters = nameValueList;
    }

    protected int getParameterAsInt(String string) {
        if (this.getParameterValue(string) != null) {
            try {
                if (this.getParameterValue(string) instanceof String) {
                    return Integer.parseInt(this.getParameter(string));
                }
                return (Integer)this.getParameterValue(string);
            }
            catch (NumberFormatException numberFormatException) {
                return -1;
            }
        }
        return -1;
    }

    protected int getParameterAsHexInt(String string) {
        if (this.getParameterValue(string) != null) {
            try {
                if (this.getParameterValue(string) instanceof String) {
                    return Integer.parseInt(this.getParameter(string), 16);
                }
                return (Integer)this.getParameterValue(string);
            }
            catch (NumberFormatException numberFormatException) {
                return -1;
            }
        }
        return -1;
    }

    protected float getParameterAsFloat(String string) {
        if (this.getParameterValue(string) != null) {
            try {
                if (this.getParameterValue(string) instanceof String) {
                    return Float.parseFloat(this.getParameter(string));
                }
                return ((Float)this.getParameterValue(string)).floatValue();
            }
            catch (NumberFormatException numberFormatException) {
                return -1.0f;
            }
        }
        return -1.0f;
    }

    protected long getParameterAsLong(String string) {
        if (this.getParameterValue(string) != null) {
            try {
                if (this.getParameterValue(string) instanceof String) {
                    return Long.parseLong(this.getParameter(string));
                }
                return (Long)this.getParameterValue(string);
            }
            catch (NumberFormatException numberFormatException) {
                return -1L;
            }
        }
        return -1L;
    }

    protected GenericURI getParameterAsURI(String string) {
        Object object = this.getParameterValue(string);
        if (object instanceof GenericURI) {
            return (GenericURI)object;
        }
        try {
            return new GenericURI((String)object);
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    protected boolean getParameterAsBoolean(String string) {
        Object object = this.getParameterValue(string);
        if (object == null) {
            return false;
        }
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        if (object instanceof String) {
            return Boolean.valueOf((String)object);
        }
        return false;
    }

    public NameValue getNameValue(String string) {
        return this.parameters.getNameValue(string);
    }

    protected abstract String encodeBody();

    public Object clone() {
        ParametersHeader parametersHeader = (ParametersHeader)super.clone();
        if (this.parameters != null) {
            parametersHeader.parameters = (NameValueList)this.parameters.clone();
        }
        return parametersHeader;
    }

    protected final boolean equalParameters(Parameters parameters) {
        String string;
        String string2;
        String string3;
        if (this == parameters) {
            return true;
        }
        Iterator iterator = this.getParameterNames();
        while (iterator.hasNext()) {
            string3 = (String)iterator.next();
            string2 = this.getParameter(string3);
            if (string2 == null ^ (string = parameters.getParameter(string3)) == null) {
                return false;
            }
            if (string2 == null || string2.equalsIgnoreCase(string)) continue;
            return false;
        }
        iterator = parameters.getParameterNames();
        while (iterator.hasNext()) {
            string3 = (String)iterator.next();
            string2 = parameters.getParameter(string3);
            if (string2 == null ^ (string = this.getParameter(string3)) == null) {
                return false;
            }
            if (string2 == null || string2.equalsIgnoreCase(string)) continue;
            return false;
        }
        return true;
    }
}

