/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.memory;

import com.hazelcast.memory.DefaultGarbageCollectorStats;
import com.hazelcast.memory.GCStatsSupport;
import com.hazelcast.memory.GarbageCollectorStats;
import com.hazelcast.memory.MemorySize;
import com.hazelcast.memory.MemoryStats;
import com.hazelcast.memory.MemoryStatsSupport;

public class DefaultMemoryStats
implements MemoryStats {
    private final Runtime runtime = Runtime.getRuntime();
    private final DefaultGarbageCollectorStats gcStats = new DefaultGarbageCollectorStats();

    @Override
    public final long getTotalPhysical() {
        return MemoryStatsSupport.totalPhysicalMemory();
    }

    @Override
    public final long getFreePhysical() {
        return MemoryStatsSupport.freePhysicalMemory();
    }

    @Override
    public final long getMaxHeap() {
        return this.runtime.maxMemory();
    }

    @Override
    public final long getCommittedHeap() {
        return this.runtime.totalMemory();
    }

    @Override
    public final long getUsedHeap() {
        return this.runtime.totalMemory() - this.runtime.freeMemory();
    }

    @Override
    public final long getFreeHeap() {
        return this.runtime.freeMemory();
    }

    @Override
    public long getMaxNativeMemory() {
        return 0L;
    }

    @Override
    public long getCommittedNativeMemory() {
        return 0L;
    }

    @Override
    public long getUsedNativeMemory() {
        return 0L;
    }

    @Override
    public long getFreeNativeMemory() {
        return 0L;
    }

    @Override
    public GarbageCollectorStats getGCStats() {
        GCStatsSupport.fill(this.gcStats);
        return this.gcStats;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("MemoryStats {");
        sb.append("Total Physical: ").append(MemorySize.toPrettyString(this.getTotalPhysical()));
        sb.append(", Free Physical: ").append(MemorySize.toPrettyString(this.getFreePhysical()));
        sb.append(", Max Heap: ").append(MemorySize.toPrettyString(this.getMaxHeap()));
        sb.append(", Committed Heap: ").append(MemorySize.toPrettyString(this.getCommittedHeap()));
        sb.append(", Used Heap: ").append(MemorySize.toPrettyString(this.getUsedHeap()));
        sb.append(", Free Heap: ").append(MemorySize.toPrettyString(this.getFreeHeap()));
        sb.append(", ");
        sb.append(this.getGCStats());
        sb.append('}');
        return sb.toString();
    }
}

