/*
 * Decompiled with CFR 0.152.
 */
package com.oopsconsultancy.xmltask.ant;

import com.oopsconsultancy.xmltask.InsertAction;
import com.oopsconsultancy.xmltask.XmlReplace;
import com.oopsconsultancy.xmltask.ant.XmlTask;
import java.io.File;
import java.util.Hashtable;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.ProjectHelper;

public class Insert {
    private XmlTask task = null;
    private String path = null;
    private InsertAction action = null;
    private InsertAction.Position position = InsertAction.Position.UNDER;

    public void setPath(String path) {
        this.path = path;
        this.register();
    }

    public void setPosition(String pos) {
        if ("before".equals(pos)) {
            this.position = InsertAction.Position.BEFORE;
        } else if ("after".equals(pos)) {
            this.position = InsertAction.Position.AFTER;
        } else if ("under".equals(pos)) {
            this.position = InsertAction.Position.UNDER;
        } else {
            this.log("Don't recognise position '" + pos + "'", 1);
        }
        if (this.action != null) {
            this.action.setPosition(this.position);
        }
    }

    private void log(String msg, int level) {
        if (this.task != null) {
            this.task.log(msg, level);
        } else {
            System.out.println(msg);
        }
    }

    public void setXml(String to) throws Exception {
        this.action = InsertAction.fromString(to, this.task);
        this.register();
    }

    public void setFile(File to) throws Exception {
        this.action = InsertAction.fromFile(to, this.task);
        this.register();
    }

    public void addText(String text) throws Exception {
        text = ProjectHelper.replaceProperties((Project)this.task.getProject(), (String)text, (Hashtable)this.task.getProject().getProperties());
        this.action = InsertAction.fromString(text, this.task);
        this.register();
    }

    public void setBuffer(String buffer) throws Exception {
        this.action = InsertAction.fromBuffer(buffer, this.task);
        this.register();
    }

    private void register() {
        if (this.action != null && this.path != null) {
            this.action.setPosition(this.position);
            this.task.add(new XmlReplace(this.path, this.action));
        }
    }

    public Insert(XmlTask task) {
        this.task = task;
    }
}

