/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Properties;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Main;
import org.apache.tools.ant.util.LoaderUtils;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class Diagnostics {
    private static final String TEST_CLASS = "org.apache.tools.ant.taskdefs.optional.Test";
    static /* synthetic */ Class class$org$apache$tools$ant$Main;
    static /* synthetic */ Class class$java$lang$Class;
    static /* synthetic */ Class array$Ljava$lang$String;

    public static final boolean isOptionalAvailable() {
        try {
            Class.forName(TEST_CLASS);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
        return true;
    }

    public static final void validateVersion() throws BuildException {
        try {
            Class<?> clazz = Class.forName(TEST_CLASS);
            Class clazz2 = class$org$apache$tools$ant$Main;
            if (clazz2 == null) {
                clazz2 = class$org$apache$tools$ant$Main = Diagnostics.class("[Lorg.apache.tools.ant.Main;", false);
            }
            String string = Diagnostics.getImplementationVersion(clazz2);
            String string2 = Diagnostics.getImplementationVersion(clazz);
            if (string != null && !string.equals(string2)) {
                throw new BuildException("Invalid implementation version between Ant core and Ant optional tasks.\n core    : " + string + "\n optional: " + string2);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {}
    }

    public static final File[] listLibraries() {
        String string = System.getProperty("ant.home");
        if (string == null) {
            return null;
        }
        File file = new File(string, "lib");
        FilenameFilter filenameFilter = new FilenameFilter(){

            public final boolean accept(File file, String string) {
                return string.endsWith(".jar");
            }
        };
        String[] stringArray = file.list(filenameFilter);
        if (stringArray == null) {
            return null;
        }
        File[] fileArray = new File[stringArray.length];
        int n = 0;
        while (n < stringArray.length) {
            fileArray[n] = new File(file, stringArray[n]);
            ++n;
        }
        return fileArray;
    }

    public static final void main(String[] stringArray) {
        Diagnostics.doReport(System.out);
    }

    private static final String getImplementationVersion(Class clazz) {
        try {
            Method method;
            Object object;
            Class clazz2 = class$java$lang$Class;
            if (clazz2 == null) {
                clazz2 = class$java$lang$Class = Diagnostics.class("[Ljava.lang.Class;", false);
            }
            if ((object = (method = clazz2.getMethod("getPackage", new Class[0])).invoke((Object)clazz, null)) != null) {
                method = object.getClass().getMethod("getImplementationVersion", new Class[0]);
                Object object2 = method.invoke(object, null);
                return (String)object2;
            }
        }
        catch (Exception exception) {
            return "?.?";
        }
        return null;
    }

    private static final String getXmlParserName() {
        SAXParser sAXParser = Diagnostics.getSAXParser();
        if (sAXParser == null) {
            return "Could not create an XML Parser";
        }
        String string = sAXParser.getClass().getName();
        return string;
    }

    private static final SAXParser getSAXParser() {
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        if (sAXParserFactory == null) {
            return null;
        }
        SAXParser sAXParser = null;
        try {
            sAXParser = sAXParserFactory.newSAXParser();
        }
        catch (Exception exception) {}
        return sAXParser;
    }

    private static final String getXMLParserLocation() {
        SAXParser sAXParser = Diagnostics.getSAXParser();
        if (sAXParser == null) {
            return null;
        }
        String string = Diagnostics.getClassLocation(sAXParser.getClass());
        return string;
    }

    private static final String getClassLocation(Class clazz) {
        File file = LoaderUtils.getClassSource(clazz);
        return file == null ? null : file.getAbsolutePath();
    }

    public static final void doReport(PrintStream printStream) {
        printStream.println("------- Ant diagnostics report -------");
        printStream.println(Main.getAntVersion());
        printStream.println();
        printStream.println("-------------------------------------------");
        printStream.println(" Implementation Version (JDK1.2+ only)");
        printStream.println("-------------------------------------------");
        StringBuffer stringBuffer = new StringBuffer("core tasks     : ");
        Class clazz = class$org$apache$tools$ant$Main;
        if (clazz == null) {
            clazz = class$org$apache$tools$ant$Main = Diagnostics.class("[Lorg.apache.tools.ant.Main;", false);
        }
        printStream.println(stringBuffer.append(Diagnostics.getImplementationVersion(clazz)).toString());
        Class<?> clazz2 = null;
        try {
            clazz2 = Class.forName(TEST_CLASS);
            printStream.println("optional tasks : " + Diagnostics.getImplementationVersion(clazz2));
        }
        catch (ClassNotFoundException classNotFoundException) {
            printStream.println("optional tasks : not available");
        }
        printStream.println();
        printStream.println("-------------------------------------------");
        printStream.println(" ANT_HOME/lib jar listing");
        printStream.println("-------------------------------------------");
        Diagnostics.doReportLibraries(printStream);
        printStream.println();
        printStream.println("-------------------------------------------");
        printStream.println(" Tasks availability");
        printStream.println("-------------------------------------------");
        Diagnostics.doReportTasksAvailability(printStream);
        printStream.println();
        printStream.println("-------------------------------------------");
        printStream.println(" org.apache.env.Which diagnostics");
        printStream.println("-------------------------------------------");
        Diagnostics.doReportWhich(printStream);
        printStream.println();
        printStream.println("-------------------------------------------");
        printStream.println(" XML Parser information");
        printStream.println("-------------------------------------------");
        Diagnostics.doReportParserInfo(printStream);
        printStream.println();
        printStream.println("-------------------------------------------");
        printStream.println(" System properties");
        printStream.println("-------------------------------------------");
        Diagnostics.doReportSystemProperties(printStream);
        printStream.println();
    }

    private static final void doReportSystemProperties(PrintStream printStream) {
        Enumeration<Object> enumeration = System.getProperties().keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            printStream.println(string + " : " + System.getProperty(string));
        }
    }

    private static final void doReportLibraries(PrintStream printStream) {
        printStream.println("ant.home: " + System.getProperty("ant.home"));
        File[] fileArray = Diagnostics.listLibraries();
        if (fileArray == null) {
            printStream.println("Unable to list libraries.");
            return;
        }
        int n = 0;
        while (n < fileArray.length) {
            printStream.println(fileArray[n].getName() + " (" + fileArray[n].length() + " bytes)");
            ++n;
        }
    }

    private static final void doReportWhich(PrintStream printStream) {
        Throwable throwable = null;
        try {
            Class<?> clazz = Class.forName("org.apache.env.Which");
            Class[] classArray = new Class[1];
            Class clazz2 = array$Ljava$lang$String;
            if (clazz2 == null) {
                clazz2 = array$Ljava$lang$String = Diagnostics.class("[Ljava.lang.String;", true);
            }
            classArray[0] = clazz2;
            Method method = clazz.getMethod("main", classArray);
            method.invoke(null, new Object[]{new String[0]});
        }
        catch (ClassNotFoundException classNotFoundException) {
            printStream.println("Not available.");
            printStream.println("Download it at http://xml.apache.org/commons/");
        }
        catch (InvocationTargetException invocationTargetException) {
            throwable = invocationTargetException.getTargetException() == null ? invocationTargetException : invocationTargetException.getTargetException();
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
        }
        if (throwable != null) {
            printStream.println("Error while running org.apache.env.Which");
            throwable.printStackTrace();
        }
    }

    private static final void doReportTasksAvailability(PrintStream printStream) {
        InputStream inputStream;
        Class clazz = class$org$apache$tools$ant$Main;
        if (clazz == null) {
            clazz = class$org$apache$tools$ant$Main = Diagnostics.class("[Lorg.apache.tools.ant.Main;", false);
        }
        if ((inputStream = clazz.getResourceAsStream("/org/apache/tools/ant/taskdefs/defaults.properties")) == null) {
            printStream.println("None available");
        } else {
            Properties properties = new Properties();
            try {
                properties.load(inputStream);
                Enumeration<Object> enumeration = properties.keys();
                while (enumeration.hasMoreElements()) {
                    String string = (String)enumeration.nextElement();
                    String string2 = properties.getProperty(string);
                    try {
                        Class.forName(string2);
                        properties.remove(string);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        printStream.println(string + " : Not Available");
                    }
                    catch (NoClassDefFoundError noClassDefFoundError) {
                        String string3 = noClassDefFoundError.getMessage().replace('/', '.');
                        printStream.println(string + " : Missing dependency " + string3);
                    }
                    catch (Error error) {
                        printStream.println(string + " : Initialization error");
                    }
                }
                if (properties.size() == 0) {
                    printStream.println("All defined tasks are available");
                }
            }
            catch (IOException iOException) {
                printStream.println(iOException.getMessage());
            }
        }
    }

    private static final void doReportParserInfo(PrintStream printStream) {
        String string = Diagnostics.getXmlParserName();
        String string2 = Diagnostics.getXMLParserLocation();
        if (string == null) {
            string = "unknown";
        }
        if (string2 == null) {
            string2 = "unknown";
        }
        printStream.println("XML Parser : " + string);
        printStream.println("XML Parser Location: " + string2);
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    private Diagnostics() {
    }
}

