/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.frontend.screens;

import com.install4j.api.ProgressInterface;
import com.install4j.runtime.installer.Uninstaller;
import com.install4j.runtime.installer.frontend.GUIHelper;
import com.install4j.runtime.installer.frontend.UninstallerScreen;
import com.install4j.runtime.installer.frontend.UninstallerWizard;
import com.install4j.runtime.installer.frontend.components.ProgressDisplay;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.io.File;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class UninstallationScreen
extends UninstallerScreen
implements ProgressInterface {
    private ProgressDisplay progressDisplay;
    private Thread uninstallerThread;
    private int currentPercent;

    public UninstallationScreen(UninstallerWizard uninstallerWizard) {
        super(uninstallerWizard);
        this.initScreen();
    }

    public void activate() {
        this.progressDisplay.activate();
        super.activate();
        this.startUninstallerThread();
    }

    protected String getTitle() {
        return MessageFormat.format(this.messages.getString("UninstallAppFullTitle"), this.getApplicationName());
    }

    protected String getSubTitle() {
        return MessageFormat.format(this.messages.getString("UninstallStatusLabel"), this.getApplicationName());
    }

    public void setStatusMessage(final String string) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                UninstallationScreen.this.progressDisplay.setStatusMessage(string);
            }
        });
    }

    public void setDetailMessage(final String string) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                UninstallationScreen.this.progressDisplay.setDetailMessage(string);
            }
        });
    }

    public void setPercentCompleted(final int n) {
        if (this.currentPercent == n) {
            return;
        }
        this.currentPercent = n;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                UninstallationScreen.this.progressDisplay.setPercentCompleted(n <= 100 ? n : 100);
            }
        });
    }

    public void setIndeterminateProgress(boolean bl) {
        this.progressDisplay.setIndeterminateProgress(bl);
    }

    public void showFailure(String string) {
        GUIHelper.showMessage(this.getParentWindow(), string, 0);
    }

    public int askOverwrite(File file) {
        throw new UnsupportedOperationException();
    }

    public int askRetry(File file) {
        throw new UnsupportedOperationException();
    }

    public boolean askContinue(File file) {
        throw new UnsupportedOperationException();
    }

    protected void addScreenContent(JPanel jPanel, GridBagConstraints gridBagConstraints) {
        jPanel.add((Component)this.progressDisplay, gridBagConstraints);
        ++gridBagConstraints.gridy;
    }

    protected void setupControls() {
        super.setupControls();
        this.progressDisplay = new ProgressDisplay();
        this.progressDisplay.setStatusMessage(MessageFormat.format(this.messages.getString("StatusUninstalling"), this.getApplicationName()));
        this.btnCancel.setEnabled(false);
        this.btnForward.setVisible(false);
        this.btnPrevious.setVisible(false);
    }

    protected boolean supportsPrevious() {
        return false;
    }

    private void startUninstallerThread() {
        this.uninstallerThread = new Thread(){

            public void run() {
                UninstallerWizard uninstallerWizard = UninstallationScreen.this.getUninstallerWizard();
                Uninstaller uninstaller = uninstallerWizard.getUninstaller();
                uninstaller.uninstall(UninstallationScreen.this);
                if (!UninstallationScreen.this.checkFailure()) {
                    uninstallerWizard.setSuccess(true);
                    uninstallerWizard.quit();
                }
            }
        };
        this.uninstallerThread.start();
    }

    private boolean checkFailure() {
        String string;
        final UninstallerWizard uninstallerWizard = this.getUninstallerWizard();
        Uninstaller uninstaller = uninstallerWizard.getUninstaller();
        List list = uninstaller.getUndeletedDirs();
        List list2 = uninstaller.getUndeletedFiles();
        StringBuffer stringBuffer = new StringBuffer();
        if (list.size() > 0) {
            this.addFailureText(list, stringBuffer);
        }
        if (list2.size() > 0) {
            this.addFailureText(list2, stringBuffer);
        }
        if ((string = stringBuffer.toString()).length() > 0) {
            uninstallerWizard.getUninstallFailureScreen().setFailureText(string);
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    uninstallerWizard.nextScreen();
                }
            });
            return true;
        }
        return false;
    }

    private void addFailureText(List list, StringBuffer stringBuffer) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            File file = (File)iterator.next();
            stringBuffer.append(file.getPath());
            stringBuffer.append("\n");
        }
    }
}

