/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.snaccmd.search;

import java.io.IOException;
import java.io.OutputStream;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.flapcmd.SnacPacket;
import net.kano.joscar.snaccmd.DirInfo;
import net.kano.joscar.snaccmd.search.SearchCommand;
import net.kano.joscar.tlv.ImmutableTlvChain;
import net.kano.joscar.tlv.Tlv;
import net.kano.joscar.tlv.TlvTools;

public class SearchBuddiesCmd
extends SearchCommand {
    public static final int TYPE_BY_DIRINFO = 0;
    public static final int TYPE_BY_EMAIL_OR_INTEREST = 1;
    private static final int TYPE_SEARCH_TYPE = 10;
    private static final int TYPE_EMAIL = 5;
    private static final int TYPE_INTEREST = 11;
    private final int type;
    private final String email;
    private final String interest;
    private final DirInfo dirInfo;

    protected SearchBuddiesCmd(SnacPacket packet) {
        super(2);
        DefensiveTools.checkNull((Object)packet, (String)"packet");
        ByteBlock snacData = packet.getData();
        ImmutableTlvChain chain = TlvTools.readChain(snacData);
        this.type = chain.getUShort(10);
        this.email = chain.getString(5);
        this.interest = chain.getString(11);
        this.dirInfo = DirInfo.readDirInfo(chain);
    }

    public static SearchBuddiesCmd createSearchByEmailCmd(String email) {
        return new SearchBuddiesCmd(1, email, null, null);
    }

    public static SearchBuddiesCmd createSearchByInterestCmd(String interest) {
        return new SearchBuddiesCmd(1, null, interest, null);
    }

    public static SearchBuddiesCmd createSearchByDirInfoCmd(DirInfo dirInfo) {
        return new SearchBuddiesCmd(0, null, null, dirInfo);
    }

    public SearchBuddiesCmd(int type, String email, String interest, DirInfo dirInfo) {
        super(2);
        DefensiveTools.checkRange((int)type, (String)"type", (int)0);
        this.type = type;
        this.email = email;
        this.interest = interest;
        this.dirInfo = dirInfo;
    }

    public final int getSearchType() {
        return this.type;
    }

    public final String getEmail() {
        return this.email;
    }

    public final String getInterest() {
        return this.interest;
    }

    public final DirInfo getDirInfo() {
        return this.dirInfo;
    }

    public void writeData(OutputStream out) throws IOException {
        Tlv.getUShortInstance(10, this.type).write(out);
        if (this.email != null) {
            Tlv.getStringInstance(5, this.email).write(out);
        }
        if (this.interest != null) {
            Tlv.getStringInstance(11, this.interest).write(out);
        }
        if (this.dirInfo != null) {
            this.dirInfo.write(out);
        }
    }

    public String toString() {
        return "SearchBuddiesCmd, type=" + this.type + ", email=" + this.email + ", interest=" + this.interest + ", dirinfo=<" + this.dirInfo + ">";
    }
}

