/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.snaccmd.conn;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.List;
import net.kano.joscar.BinaryTools;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.Writable;
import net.kano.joscar.snac.CmdType;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RateClassInfo
implements Writable {
    private static final int RATECLASSINFO_SIZE = 35;
    private final int rateClass;
    private final long windowSize;
    private final long warnAvg;
    private final long limitedAvg;
    private final long clearAvg;
    private final long disconnectAvg;
    private final long currentAvg;
    private final long max;
    private final long lastTime;
    private final int currentState;
    private List<CmdType> commands = null;

    @Nullable
    public static RateClassInfo readRateClassInfo(ByteBlock block) {
        if (block.getLength() < 35) {
            return null;
        }
        return new RateClassInfo(block);
    }

    private RateClassInfo(ByteBlock block) {
        this.rateClass = BinaryTools.getUShort((ByteBlock)block, (int)0);
        this.windowSize = BinaryTools.getUInt((ByteBlock)block, (int)2);
        this.clearAvg = BinaryTools.getUInt((ByteBlock)block, (int)6);
        this.warnAvg = BinaryTools.getUInt((ByteBlock)block, (int)10);
        this.limitedAvg = BinaryTools.getUInt((ByteBlock)block, (int)14);
        this.disconnectAvg = BinaryTools.getUInt((ByteBlock)block, (int)18);
        this.currentAvg = BinaryTools.getUInt((ByteBlock)block, (int)22);
        this.max = BinaryTools.getUInt((ByteBlock)block, (int)26);
        if (block.getLength() >= 34) {
            this.lastTime = BinaryTools.getUInt((ByteBlock)block, (int)30);
            this.currentState = block.getLength() >= 35 ? (int)BinaryTools.getUByte((ByteBlock)block, (int)34) : 0;
        } else {
            this.lastTime = 0L;
            this.currentState = 0;
        }
    }

    synchronized void setCommands(Collection<? extends CmdType> commands) {
        this.commands = DefensiveTools.getSafeListCopy(commands, (String)"commands");
    }

    public RateClassInfo(int rateClass, long windowSize, long clearAvg, long warnAvg, long limitedAvg, long disconnectAvg, long currentAvg, long max, long lastTime, int currentState) {
        DefensiveTools.checkRange((int)rateClass, (String)"rateClass", (int)0);
        DefensiveTools.checkRange((long)windowSize, (String)"windowSize", (long)0L);
        DefensiveTools.checkRange((long)clearAvg, (String)"clearAvg", (long)0L);
        DefensiveTools.checkRange((long)warnAvg, (String)"warnAvg", (long)0L);
        DefensiveTools.checkRange((long)limitedAvg, (String)"limitedAvg", (long)0L);
        DefensiveTools.checkRange((long)disconnectAvg, (String)"disconnectAvg", (long)0L);
        DefensiveTools.checkRange((long)currentAvg, (String)"currentAvg", (long)0L);
        DefensiveTools.checkRange((long)max, (String)"max", (long)0L);
        DefensiveTools.checkRange((long)max, (String)"lastTime", (long)0L);
        DefensiveTools.checkRange((long)max, (String)"currentState", (long)0L);
        this.rateClass = rateClass;
        this.windowSize = windowSize;
        this.clearAvg = clearAvg;
        this.warnAvg = warnAvg;
        this.limitedAvg = limitedAvg;
        this.disconnectAvg = disconnectAvg;
        this.currentAvg = currentAvg;
        this.max = max;
        this.lastTime = lastTime;
        this.currentState = currentState;
    }

    public RateClassInfo(int rateClass, long windowSize, long clearAvg, long warnAvg, long limitedAvg, long disconnectAvg, long currentAvg, long max) {
        this(rateClass, windowSize, clearAvg, warnAvg, limitedAvg, disconnectAvg, currentAvg, max, 0L, 0);
    }

    public RateClassInfo(int rateClass, long windowSize, long clearAvg, long warnAvg, long limitedAvg, long disconnectAvg, long currentAvg, long max, Collection<? extends CmdType> cmds) {
        this(rateClass, windowSize, clearAvg, warnAvg, limitedAvg, disconnectAvg, currentAvg, max);
        this.setCommands(cmds);
    }

    public RateClassInfo(int rateClass, long windowSize, long clearAvg, long warnAvg, long limitedAvg, long disconnectAvg, long currentAvg, long max, long lastTime, int currentState, Collection<? extends CmdType> cmds) {
        this(rateClass, windowSize, clearAvg, warnAvg, limitedAvg, disconnectAvg, currentAvg, max, lastTime, currentState);
        this.setCommands(cmds);
    }

    public final int getRateClass() {
        return this.rateClass;
    }

    public final long getWindowSize() {
        return this.windowSize;
    }

    public final long getWarnAvg() {
        return this.warnAvg;
    }

    public final long getLimitedAvg() {
        return this.limitedAvg;
    }

    public final long getClearAvg() {
        return this.clearAvg;
    }

    public final long getDisconnectAvg() {
        return this.disconnectAvg;
    }

    public final long getCurrentAvg() {
        return this.currentAvg;
    }

    public final long getMax() {
        return this.max;
    }

    public int getCurrentState() {
        return this.currentState;
    }

    public long getLastTime() {
        return this.lastTime;
    }

    public final synchronized List<CmdType> getCommands() {
        return this.commands;
    }

    public long getWritableLength() {
        return 35L;
    }

    public void write(OutputStream out) throws IOException {
        BinaryTools.writeUShort((OutputStream)out, (int)this.rateClass);
        BinaryTools.writeUInt((OutputStream)out, (long)this.windowSize);
        BinaryTools.writeUInt((OutputStream)out, (long)this.clearAvg);
        BinaryTools.writeUInt((OutputStream)out, (long)this.warnAvg);
        BinaryTools.writeUInt((OutputStream)out, (long)this.limitedAvg);
        BinaryTools.writeUInt((OutputStream)out, (long)this.disconnectAvg);
        BinaryTools.writeUInt((OutputStream)out, (long)this.currentAvg);
        BinaryTools.writeUInt((OutputStream)out, (long)this.max);
        BinaryTools.writeUInt((OutputStream)out, (long)this.lastTime);
        BinaryTools.writeUByte((OutputStream)out, (int)this.currentState);
    }

    public synchronized String toString() {
        return "RateClassInfo for class " + this.rateClass + ", currentAvg=" + this.currentAvg + ", windowSize=" + this.windowSize + ", clearAvg=" + this.clearAvg + ", warnAvg=" + this.warnAvg + ", limitedAvg=" + this.limitedAvg + ", disconnectAvg=" + this.disconnectAvg + ", max=" + this.max + ", lastTime=" + this.lastTime + ", currentState=" + this.currentState + ", families: " + (this.commands == null ? "none" : "" + this.commands.size());
    }
}

