/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.snaccmd.conn;

import java.util.List;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.flapcmd.SnacCommand;
import net.kano.joscar.flapcmd.SnacPacket;
import net.kano.joscar.snac.CmdType;
import net.kano.joscar.snac.SnacCmdFactory;
import net.kano.joscar.snaccmd.conn.EncryptionInfoAck;
import net.kano.joscar.snaccmd.conn.ExtraInfoAck;
import net.kano.joscar.snaccmd.conn.MigrationNotice;
import net.kano.joscar.snaccmd.conn.Noop;
import net.kano.joscar.snaccmd.conn.PauseCmd;
import net.kano.joscar.snaccmd.conn.RateChange;
import net.kano.joscar.snaccmd.conn.RateInfoCmd;
import net.kano.joscar.snaccmd.conn.ResumeCmd;
import net.kano.joscar.snaccmd.conn.ServerReadyCmd;
import net.kano.joscar.snaccmd.conn.ServerVersionsCmd;
import net.kano.joscar.snaccmd.conn.ServiceRedirect;
import net.kano.joscar.snaccmd.conn.UpdateAdvisory;
import net.kano.joscar.snaccmd.conn.WarningNotification;
import net.kano.joscar.snaccmd.conn.YourInfoCmd;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientConnCmdFactory
implements SnacCmdFactory {
    protected static final List<CmdType> SUPPORTED_TYPES = DefensiveTools.asUnmodifiableList((Object[])new CmdType[]{new CmdType(1, 3), new CmdType(1, 24), new CmdType(1, 7), new CmdType(1, 15), new CmdType(1, 16), new CmdType(1, 19), new CmdType(1, 10), new CmdType(1, 22), new CmdType(1, 5), new CmdType(1, 11), new CmdType(1, 13), new CmdType(1, 18), new CmdType(1, 33), new CmdType(1, 35)});

    @Override
    public List<CmdType> getSupportedTypes() {
        return SUPPORTED_TYPES;
    }

    @Override
    public SnacCommand genSnacCommand(SnacPacket packet) {
        if (packet.getFamily() != 1) {
            return null;
        }
        int command = packet.getCommand();
        if (command == 3) {
            return new ServerReadyCmd(packet);
        }
        if (command == 24) {
            return new ServerVersionsCmd(packet);
        }
        if (command == 7) {
            return new RateInfoCmd(packet);
        }
        if (command == 15) {
            return new YourInfoCmd(packet);
        }
        if (command == 16) {
            return new WarningNotification(packet);
        }
        if (command == 19) {
            return new UpdateAdvisory(packet);
        }
        if (command == 10) {
            return new RateChange(packet);
        }
        if (command == 22) {
            return new Noop(packet);
        }
        if (command == 5) {
            return new ServiceRedirect(packet);
        }
        if (command == 11) {
            return new PauseCmd(packet);
        }
        if (command == 13) {
            return new ResumeCmd(packet);
        }
        if (command == 18) {
            return new MigrationNotice(packet);
        }
        if (command == 33) {
            return new ExtraInfoAck(packet);
        }
        if (command == 35) {
            return new EncryptionInfoAck(packet);
        }
        return null;
    }
}

