/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.rv;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.kano.joscar.CopyOnWriteArrayList;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.SeqNum;
import net.kano.joscar.flap.FlapProcessor;
import net.kano.joscar.flapcmd.SnacCommand;
import net.kano.joscar.logging.Logger;
import net.kano.joscar.logging.LoggingSystem;
import net.kano.joscar.net.ConnProcessor;
import net.kano.joscar.rv.NewRvSessionEvent;
import net.kano.joscar.rv.RecvRvEvent;
import net.kano.joscar.rv.RvCommandFactory;
import net.kano.joscar.rv.RvProcessorListener;
import net.kano.joscar.rv.RvSession;
import net.kano.joscar.rv.RvSessionListener;
import net.kano.joscar.rv.RvSnacResponseEvent;
import net.kano.joscar.snac.ClientSnacProcessor;
import net.kano.joscar.snac.SnacPacketEvent;
import net.kano.joscar.snac.SnacRequest;
import net.kano.joscar.snac.SnacRequestAdapter;
import net.kano.joscar.snac.SnacRequestListener;
import net.kano.joscar.snac.SnacResponseEvent;
import net.kano.joscar.snac.VetoableSnacPacketListener;
import net.kano.joscar.snaccmd.CapabilityBlock;
import net.kano.joscar.snaccmd.icbm.RecvRvIcbm;
import net.kano.joscar.snaccmd.icbm.RvCommand;
import net.kano.joscar.snaccmd.icbm.RvResponse;
import net.kano.joscar.snaccmd.icbm.SendRvIcbm;
import net.kano.joustsim.Screenname;
import org.jetbrains.annotations.Nullable;

public class RvProcessor {
    public static final ConnProcessor.ErrorType ERRTYPE_RV_CMD_GEN = new ConnProcessor.ErrorType("ERRTYPE_RV_CMD_GEN");
    public static final ConnProcessor.ErrorType ERRTYPE_RV_LISTENER = new ConnProcessor.ErrorType("ERRTYPE_RV_LISTENER");
    public static final ConnProcessor.ErrorType ERRTYPE_RV_SESSION_LISTENER = new ConnProcessor.ErrorType("ERRTYPE_RV_SESSION_LISTENER");
    private static final Logger logger = LoggingSystem.getLogger("net.kano.joscar.rv");
    private ClientSnacProcessor snacProcessor = null;
    private final Object sessionLock = new Object();
    private SeqNum sessionId = new SeqNum(Long.MIN_VALUE, Long.MAX_VALUE, new Random().nextLong());
    private Map<RvSessionMapKey, RvSessionImpl> sessions = new HashMap<RvSessionMapKey, RvSessionImpl>();
    private CopyOnWriteArrayList<RvProcessorListener> rvListeners = new CopyOnWriteArrayList();
    private Map<CapabilityBlock, RvCommandFactory> rvFactories = new HashMap<CapabilityBlock, RvCommandFactory>();
    private VetoableSnacPacketListener packetListener = new VetoableSnacPacketListener(){

        public Object handlePacket(SnacPacketEvent event) {
            SnacCommand cmd = event.getSnacCommand();
            if (cmd instanceof RecvRvIcbm) {
                if (logger.logFinerEnabled()) {
                    logger.logFiner("RvProcessor got RecvRvIcbm: " + cmd);
                }
                RvProcessor.this.processRv(event);
                return STOP_PROCESSING_LISTENERS;
            }
            if (cmd instanceof RvResponse) {
                if (logger.logFinerEnabled()) {
                    logger.logFiner("RvProcessor got RvResponse: " + cmd);
                }
                RvProcessor.this.processResponse(event);
                return STOP_PROCESSING_LISTENERS;
            }
            return CONTINUE_PROCESSING;
        }
    };

    public RvProcessor() {
    }

    public RvProcessor(ClientSnacProcessor snacProcessor) {
        this.attachToSnacProcessor(snacProcessor);
    }

    public final synchronized ClientSnacProcessor getSnacProcessor() {
        return this.snacProcessor;
    }

    public final synchronized void attachToSnacProcessor(ClientSnacProcessor snacProcessor) {
        DefensiveTools.checkNull((Object)snacProcessor, (String)"snacProcessor");
        this.detach();
        this.snacProcessor = snacProcessor;
        snacProcessor.addVetoablePacketListener(this.packetListener);
    }

    public final synchronized void detach() {
        if (this.snacProcessor != null) {
            this.snacProcessor.removeVetoablePacketListener(this.packetListener);
            this.snacProcessor = null;
        }
    }

    public final void addListener(RvProcessorListener l) {
        DefensiveTools.checkNull((Object)l, (String)"l");
        this.rvListeners.addIfAbsent((Object)l);
    }

    public final void removeListener(RvProcessorListener l) {
        DefensiveTools.checkNull((Object)l, (String)"l");
        this.rvListeners.remove((Object)l);
    }

    public final synchronized void registerRvCmdFactory(RvCommandFactory factory) {
        DefensiveTools.checkNull((Object)factory, (String)"factory");
        List<CapabilityBlock> blocks = factory.getSupportedCapabilities();
        if (blocks == null) {
            this.registerRvCmdFactory(null, factory);
        } else {
            for (CapabilityBlock block : blocks) {
                this.registerRvCmdFactory(block, factory);
            }
        }
    }

    public final synchronized void registerRvCmdFactory(CapabilityBlock cap, RvCommandFactory factory) {
        DefensiveTools.checkNull((Object)factory, (String)"factory");
        this.rvFactories.put(cap, factory);
    }

    public final synchronized RvCommandFactory getRegisteredRvCmdFactory(CapabilityBlock cap) {
        return this.rvFactories.get(cap);
    }

    public final synchronized void unregisterRvCmdFactory(RvCommandFactory factory) {
        DefensiveTools.checkNull((Object)factory, (String)"factory");
        this.rvFactories.values().remove(factory);
    }

    public final synchronized void unregisterRvCmdFactory(CapabilityBlock cap, RvCommandFactory factory) {
        DefensiveTools.checkNull((Object)factory, (String)"factory");
        if (this.rvFactories.get(cap) == factory) {
            this.rvFactories.remove(cap);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private RvCommand genRvCommand(RecvRvIcbm icbm) {
        RvCommandFactory factory;
        DefensiveTools.checkNull((Object)icbm, (String)"icbm");
        RvProcessor rvProcessor = this;
        synchronized (rvProcessor) {
            factory = this.rvFactories.get(icbm.getCapability());
            if (factory == null) {
                factory = this.rvFactories.get(null);
            }
        }
        if (factory == null) {
            logger.logWarning("No rendezvous factory is present in RvProcessor; rendezvous packets cannot be processed");
            return null;
        }
        return factory.genRvCommand(icbm);
    }

    private synchronized RvSessionImpl getSession(long sessionId, String sn) {
        DefensiveTools.checkNull((Object)sn, (String)"sn");
        RvSessionMapKey key = new RvSessionMapKey(sessionId, sn);
        return this.sessions.get(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RvSessionImpl getOrCreateIncomingSession(long sessionId, String sn) {
        DefensiveTools.checkNull((Object)sn, (String)"sn");
        RvSessionImpl session = this.getSession(sessionId, sn);
        if (session == null) {
            if (logger.logFineEnabled()) {
                logger.logFine("Creating new incoming RV session for " + sn + ", id=0x" + Long.toHexString(sessionId));
            }
            Object object = this.sessionLock;
            synchronized (object) {
                session = this.createNewSession(sessionId, sn);
                this.fireNewSessionEvent(session, NewRvSessionEvent.TYPE_INCOMING);
            }
        }
        return session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleException(ConnProcessor.ErrorType type, Throwable t, Object info) {
        FlapProcessor fp;
        ClientSnacProcessor processor;
        DefensiveTools.checkNull((Object)type, (String)"type");
        DefensiveTools.checkNull((Object)t, (String)"t");
        if (logger.logFineEnabled()) {
            logger.logFiner("RV processor got exception type " + type + ": " + t + " - " + info);
        }
        RvProcessor rvProcessor = this;
        synchronized (rvProcessor) {
            processor = this.snacProcessor;
        }
        if (processor != null && (fp = processor.getFlapProcessor()) != null) {
            fp.handleException(type, t, info);
            return;
        }
        logger.logWarning("RV processor got exception; no exception handlerspresent (type=" + type + ", info=" + info + ")");
        logger.logWarning(Arrays.asList(t.getStackTrace()).toString());
    }

    private void fireNewSessionEvent(RvSessionImpl session, NewRvSessionEvent.EventType type) {
        NewRvSessionEvent event = new NewRvSessionEvent(this, session, type);
        for (RvProcessorListener listener : this.rvListeners) {
            try {
                listener.handleNewSession(event);
            }
            catch (Throwable t) {
                this.handleException(ERRTYPE_RV_LISTENER, t, listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RvSessionImpl createNewSession(long sessionId, String sn) {
        RvSessionImpl session = new RvSessionImpl(sessionId, sn);
        RvSessionMapKey key = new RvSessionMapKey(sessionId, sn);
        Object object = this.sessionLock;
        synchronized (object) {
            this.sessions.put(key, session);
        }
        return session;
    }

    private void processRv(SnacPacketEvent e) {
        RvCommand rvCommand;
        RecvRvIcbm cmd = (RecvRvIcbm)e.getSnacCommand();
        if (logger.logFinerEnabled()) {
            logger.logFiner("Generating RV for <" + cmd.getCapability() + "> from " + cmd.getSenderInfo().getScreenname());
        }
        RvSessionImpl session = this.getOrCreateIncomingSession(cmd.getRvSessionId(), cmd.getSenderInfo().getScreenname());
        try {
            rvCommand = this.genRvCommand(cmd);
        }
        catch (Throwable t) {
            this.handleException(ERRTYPE_RV_CMD_GEN, t, cmd);
            return;
        }
        boolean logFine = logger.logFineEnabled();
        if (logFine) {
            if (rvCommand == null) {
                logger.logFiner("Couldn't generate RV command, data was:" + cmd.getRvData());
            } else {
                logger.logFiner("Generated RV command: " + rvCommand);
            }
        }
        if (rvCommand == null) {
            return;
        }
        RecvRvEvent event = new RecvRvEvent(e, this, (RvSession)session, rvCommand);
        session.processRv(event);
        logger.logFiner("Done processing RV");
    }

    private void processResponse(SnacPacketEvent e) {
        RvResponse cmd = (RvResponse)e.getSnacCommand();
        RvSessionImpl session = this.getOrCreateIncomingSession(cmd.getRvSessionId(), cmd.getScreenname());
        RecvRvEvent event = new RecvRvEvent(e, this, (RvSession)session, cmd.getResultCode());
        session.processRv(event);
        if (logger.logFinerEnabled()) {
            logger.logFiner("Done processing RV response");
        }
    }

    public final RvSession createRvSession(String sn) {
        DefensiveTools.checkNull((Object)sn, (String)"sn");
        return this.createRvSession(sn, this.sessionId.next());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final RvSession createRvSession(String sn, long sessionID) {
        RvSessionImpl session;
        DefensiveTools.checkNull((Object)sn, (String)"sn");
        if (logger.logFinerEnabled()) {
            logger.logFiner("Creating new outgoing RV session for " + sn);
        }
        Object object = this.sessionLock;
        synchronized (object) {
            session = this.createNewSession(sessionID, sn);
            this.fireNewSessionEvent(session, NewRvSessionEvent.TYPE_OUTGOING);
        }
        return session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendSnac(SnacRequest req) {
        ClientSnacProcessor processor;
        RvProcessor rvProcessor = this;
        synchronized (rvProcessor) {
            processor = this.snacProcessor;
        }
        if (processor == null) {
            return;
        }
        processor.sendSnac(req);
    }

    public String toString() {
        return "RvProcessor: lastSessionId=" + this.sessionId.getLast() + ", sessions=" + this.sessions.keySet();
    }

    private class RvSessionImpl
    implements RvSession {
        private final long rvSessionId;
        private final String sn;
        private CopyOnWriteArrayList<RvSessionListener> listeners = new CopyOnWriteArrayList();
        private SnacRequestListener reqListener = new SnacRequestAdapter(){

            public void handleResponse(SnacResponseEvent e) {
                RvSnacResponseEvent event = new RvSnacResponseEvent(e, RvProcessor.this, RvSessionImpl.this);
                RvSessionImpl.this.processSnacResponse(event);
            }
        };

        private RvSessionImpl(long rvSessionId, String sn) {
            this.rvSessionId = rvSessionId;
            this.sn = sn;
        }

        public RvProcessor getRvProcessor() {
            return RvProcessor.this;
        }

        public long getRvSessionId() {
            return this.rvSessionId;
        }

        public String getScreenname() {
            return this.sn;
        }

        public void addListener(RvSessionListener l) {
            DefensiveTools.checkNull((Object)l, (String)"l");
            this.listeners.addIfAbsent((Object)l);
        }

        public void removeListener(RvSessionListener l) {
            DefensiveTools.checkNull((Object)l, (String)"l");
            this.listeners.remove((Object)l);
        }

        private void processRv(RecvRvEvent event) {
            for (RvSessionListener listener : this.listeners) {
                try {
                    listener.handleRv(event);
                }
                catch (Throwable t) {
                    RvProcessor.this.handleException(ERRTYPE_RV_SESSION_LISTENER, t, listener);
                }
            }
        }

        private void processSnacResponse(RvSnacResponseEvent event) {
            for (RvSessionListener listener : this.listeners) {
                try {
                    listener.handleSnacResponse(event);
                }
                catch (Throwable t) {
                    RvProcessor.this.handleException(ERRTYPE_RV_SESSION_LISTENER, t, listener);
                }
            }
        }

        public void sendRv(RvCommand command) {
            this.sendRv(command, this.getRvSessionId());
        }

        public void sendRv(RvCommand command, long icbmMessageId) {
            DefensiveTools.checkNull((Object)command, (String)"command");
            if (logger.logFineEnabled()) {
                logger.logFine("Sending RV to " + this.sn + ": " + command);
            }
            SendRvIcbm cmd = new SendRvIcbm(this.sn, icbmMessageId, this.rvSessionId, command);
            RvProcessor.this.sendSnac(new SnacRequest(cmd, this.reqListener));
        }

        public void sendResponse(int code) {
            RvResponse cmd = new RvResponse(this.rvSessionId, 2, this.sn, code);
            if (logger.logFineEnabled()) {
                logger.logFine("Sending RV response to " + this.sn + ": " + code);
            }
            RvProcessor.this.sendSnac(new SnacRequest(cmd, this.reqListener));
        }

        public String toString() {
            return "RvSession with " + this.getScreenname() + " (sessionid=0x" + Long.toHexString(this.rvSessionId) + ")";
        }
    }

    private static class RvSessionMapKey {
        private final long sessionId;
        private final String sn;

        private RvSessionMapKey(long sessionId, String sn) {
            this.sessionId = sessionId;
            this.sn = Screenname.normalize((String)sn);
        }

        public int hashCode() {
            return (int)(this.sessionId >> 32 ^ this.sessionId ^ (long)this.sn.hashCode());
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof RvSessionMapKey)) {
                return false;
            }
            RvSessionMapKey key = (RvSessionMapKey)obj;
            return this.sessionId == key.sessionId && this.sn.equals(key.sn);
        }

        public String toString() {
            return "(" + this.sn + ", " + this.sessionId + ")";
        }
    }
}

