/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar;

import net.kano.joscar.BinaryTools;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;

public class DynAsciiCharSequence
implements CharSequence {
    private final ByteBlock data;
    private int length;

    public DynAsciiCharSequence(ByteBlock data) {
        DefensiveTools.checkNull((Object)data, (String)"data");
        this.data = data;
        this.length = data.getLength();
    }

    public void setLength(int length) {
        this.length = length;
    }

    public char charAt(int index) {
        return (char)this.data.get(index);
    }

    public int length() {
        return this.length;
    }

    public DynAsciiCharSequence subSequence(int start, int end) {
        return new DynAsciiCharSequence(this.data.subBlock(start, end - start));
    }

    public String toString() {
        return BinaryTools.getAsciiString((ByteBlock)this.data.subBlock(0, this.length));
    }

    public boolean contains(CharSequence target) {
        return this.indexOf(target) != -1;
    }

    public int indexOf(CharSequence target) {
        return this.indexOf(target, 0);
    }

    public int indexOf(CharSequence target, int fromIndex) {
        DefensiveTools.checkRange((int)fromIndex, (String)"fromIndex", (int)0);
        int sourceCount = this.length();
        int targetCount = target.length();
        if (fromIndex >= sourceCount) {
            return targetCount == 0 ? sourceCount : -1;
        }
        if (targetCount == 0) {
            return fromIndex;
        }
        char first = target.charAt(0);
        int max = sourceCount - targetCount;
        for (int i = fromIndex; i <= max; ++i) {
            if (this.charAt(i) != first) {
                while (++i <= max && this.charAt(i) != first) {
                }
            }
            if (i > max) continue;
            int j = i + 1;
            int end = j + targetCount - 1;
            int k = 1;
            while (j < end && this.charAt(j) == target.charAt(k)) {
                ++j;
                ++k;
            }
            if (j != end) continue;
            return i;
        }
        return -1;
    }
}

