/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jml.impl;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import net.sf.jml.MsnConnection;
import net.sf.jml.MsnFileTransfer;
import net.sf.jml.MsnMessageChain;
import net.sf.jml.impl.AbstractMessenger;
import net.sf.jml.impl.AbstractSwitchboard;
import net.sf.jml.impl.BasicMessenger;
import net.sf.jml.impl.MsnConnectionImpl;
import net.sf.jml.message.MsnMimeMessage;
import net.sf.jml.net.Session;
import net.sf.jml.net.SessionAdapter;
import net.sf.jml.net.SessionListener;
import net.sf.jml.protocol.MsnOutgoingMessage;
import net.sf.jml.protocol.MsnSession;
import net.sf.jml.protocol.outgoing.OutgoingANS;
import net.sf.jml.protocol.outgoing.OutgoingMSG;
import net.sf.jml.protocol.outgoing.OutgoingUSRAuthSB;

public abstract class BasicSwitchboard
extends AbstractSwitchboard {
    private final MsnSession session;
    private final MsnConnectionImpl connection = new MsnConnectionImpl();
    private final boolean createdByOwner;
    private String authStr;
    private int sessionId;
    private final int SESSION_ACTIVITY_TIMEOUT = 300000;
    private long lastActivityUpdate = 0L;

    public BasicSwitchboard(BasicMessenger basicMessenger, boolean bl, String string, int n) {
        super(basicMessenger);
        this.createdByOwner = bl;
        this.connection.setRemoteIP(string);
        this.connection.setRemotePort(n);
        this.connection.setConnectionType(basicMessenger.getConnection().getConnectionType());
        this.session = new MsnSession(this, (SocketAddress)new InetSocketAddress(string, n));
        this.session.addSessionListener(new SBSessionListener());
    }

    public MsnConnection getConnection() {
        return this.connection;
    }

    public synchronized void close() {
        MsnFileTransfer[] msnFileTransferArray;
        for (MsnFileTransfer msnFileTransfer : msnFileTransferArray = this.getActiveFileTransfers()) {
            msnFileTransfer.cancel();
        }
        this.session.close();
    }

    public MsnMessageChain getIncomingMessageChain() {
        if (this.session == null) {
            return null;
        }
        return this.session.getIncomingMessageChain();
    }

    public MsnMessageChain getOutgoingMessageChain() {
        if (this.session == null) {
            return null;
        }
        return this.session.getOutgoingMessageChain();
    }

    public boolean sendMessage(MsnMimeMessage msnMimeMessage, boolean bl) {
        OutgoingMSG[] outgoingMSGArray;
        if (msnMimeMessage != null && (outgoingMSGArray = msnMimeMessage.toOutgoingMsg(this.getMessenger().getActualMsnProtocol())) != null) {
            for (OutgoingMSG outgoingMSG : outgoingMSGArray) {
                if (this.send(outgoingMSG, bl) || !bl) continue;
                return false;
            }
            if (bl) {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean send(MsnOutgoingMessage msnOutgoingMessage, boolean bl) {
        BasicSwitchboard basicSwitchboard = this;
        synchronized (basicSwitchboard) {
            this.lastActivityUpdate = System.currentTimeMillis();
            this.session.setSessionTimeout(300000);
        }
        if (bl) {
            return this.session.sendSynchronousMessage(msnOutgoingMessage);
        }
        this.session.sendAsynchronousMessage(msnOutgoingMessage);
        return false;
    }

    public String toString() {
        return "MsnSwitchboard: " + this.getMessenger().getOwner().getEmail();
    }

    public void setAuthStr(String string) {
        this.authStr = string;
    }

    public void setSessionId(int n) {
        this.sessionId = n;
    }

    public synchronized void start() {
        this.session.start();
    }

    public void addSessionListener(SessionListener sessionListener) {
        this.session.addSessionListener(sessionListener);
    }

    public void removeSessionListener(SessionListener sessionListener) {
        this.session.removeSessionListener(sessionListener);
    }

    private class SBSessionListener
    extends SessionAdapter {
        private SBSessionListener() {
        }

        public void sessionEstablished(Session session) {
            if (BasicSwitchboard.this.createdByOwner) {
                OutgoingUSRAuthSB outgoingUSRAuthSB = new OutgoingUSRAuthSB(BasicSwitchboard.this.getMessenger().getActualMsnProtocol());
                outgoingUSRAuthSB.setEmail(BasicSwitchboard.this.getMessenger().getOwner().getEmail());
                outgoingUSRAuthSB.setAuthStr(BasicSwitchboard.this.authStr);
                BasicSwitchboard.this.send(outgoingUSRAuthSB, false);
            } else {
                OutgoingANS outgoingANS = new OutgoingANS(BasicSwitchboard.this.getMessenger().getActualMsnProtocol());
                outgoingANS.setEmail(BasicSwitchboard.this.getMessenger().getOwner().getEmail());
                outgoingANS.setAuthStr(BasicSwitchboard.this.authStr);
                outgoingANS.setSessionId(BasicSwitchboard.this.sessionId);
                BasicSwitchboard.this.send(outgoingANS, false);
            }
            BasicSwitchboard.this.connection.setInternalIP(BasicSwitchboard.this.session.getLocalAddress());
            BasicSwitchboard.this.connection.setInternalPort(BasicSwitchboard.this.session.getLocalPort());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void sessionTimeout(Session session) {
            SBSessionListener sBSessionListener = this;
            synchronized (sBSessionListener) {
                if (System.currentTimeMillis() - BasicSwitchboard.this.lastActivityUpdate >= 300000L) {
                    session.close();
                }
            }
        }

        public void sessionClosed(Session session) {
            ((AbstractMessenger)BasicSwitchboard.this.getMessenger()).fireSwitchboardClosed(BasicSwitchboard.this);
        }
    }
}

