/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.snaccmd.conn;

import java.io.IOException;
import java.io.OutputStream;
import net.kano.joscar.BinaryTools;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.Writable;

public class SnacFamilyInfo
implements Writable {
    private final int family;
    private final int version;
    private final int toolID;
    private final int toolVersion;

    protected static SnacFamilyInfo readSnacFamilyInfo(ByteBlock block) {
        DefensiveTools.checkNull((Object)block, (String)"block");
        int family = BinaryTools.getUShort((ByteBlock)block, (int)0);
        int version = BinaryTools.getUShort((ByteBlock)block, (int)2);
        int toolid = BinaryTools.getUShort((ByteBlock)block, (int)4);
        int toolver = BinaryTools.getUShort((ByteBlock)block, (int)6);
        return new SnacFamilyInfo(family, version, toolid, toolver);
    }

    public SnacFamilyInfo(int family, int version) {
        this(family, version, -1, -1);
    }

    public SnacFamilyInfo(int family, int version, int toolID, int toolVersion) {
        DefensiveTools.checkRange((int)family, (String)"family", (int)0);
        DefensiveTools.checkRange((int)version, (String)"version", (int)0);
        DefensiveTools.checkRange((int)toolID, (String)"toolID", (int)-1);
        DefensiveTools.checkRange((int)toolVersion, (String)"toolVersion", (int)-1);
        this.family = family;
        this.version = version;
        this.toolID = toolID;
        this.toolVersion = toolVersion;
    }

    public final int getFamily() {
        return this.family;
    }

    public final int getVersion() {
        return this.version;
    }

    public final int getToolID() {
        return this.toolID;
    }

    public final int getToolVersion() {
        return this.toolVersion;
    }

    public long getWritableLength() {
        return 8L;
    }

    public void write(OutputStream out) throws IOException {
        BinaryTools.writeUShort((OutputStream)out, (int)this.family);
        BinaryTools.writeUShort((OutputStream)out, (int)this.version);
        if (this.toolID != -1 && this.toolVersion != -1) {
            BinaryTools.writeUShort((OutputStream)out, (int)this.toolID);
            BinaryTools.writeUShort((OutputStream)out, (int)this.toolVersion);
        }
    }

    public String toString() {
        return "SnacFamilyInfo: family=0x" + Integer.toHexString(this.family) + ", version=0x" + Integer.toHexString(this.version) + ", toolID=0x" + Integer.toHexString(this.toolID) + ", toolVersion=0x" + Integer.toHexString(this.toolVersion);
    }
}

