/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.babel.dtd;

import java.io.IOException;
import weblogic.xml.babel.baseparser.BaseParser;
import weblogic.xml.babel.baseparser.ParseException;
import weblogic.xml.babel.baseparser.Space;
import weblogic.xml.babel.dtd.Declaration;
import weblogic.xml.babel.dtd.Name;
import weblogic.xml.babel.scanner.ScannerException;

public class NotationDeclaration
extends Declaration {
    private Name name;
    private Space space;
    private boolean publicID;
    private boolean externalID;
    private String systemLiteral;
    private String pubidLiteral;
    private boolean isSYSTEM;

    public NotationDeclaration() {
        this.init();
    }

    public void init() {
        super.init();
        this.name = new Name();
        this.space = new Space();
        this.publicID = false;
        this.externalID = false;
        this.systemLiteral = "";
        this.pubidLiteral = "";
    }

    public void parse(BaseParser baseParser) throws IOException, ScannerException, ParseException {
        this.init();
        baseParser.accept(55);
        this.space.parse(baseParser);
        this.name.parse(baseParser);
        this.space.parse(baseParser);
        switch (baseParser.getCurrentToken().tokenType) {
            case 25: {
                this.isSYSTEM = true;
                baseParser.accept();
                this.space.parse(baseParser);
                if (baseParser.compare(13)) {
                    this.systemLiteral = baseParser.getCurrentToken().getArrayAsString();
                    baseParser.accept();
                } else {
                    this.systemLiteral = "";
                }
                this.externalID = true;
                break;
            }
            case 26: {
                this.isSYSTEM = false;
                baseParser.accept();
                this.space.parse(baseParser);
                if (baseParser.compare(13)) {
                    this.pubidLiteral = baseParser.getCurrentToken().getArrayAsString();
                    baseParser.accept();
                } else {
                    this.pubidLiteral = "";
                }
                this.space.parse(baseParser);
                if (baseParser.getCurrentToken().tokenType == 13) {
                    this.systemLiteral = baseParser.getCurrentToken().getArrayAsString();
                    baseParser.accept();
                    this.publicID = false;
                    this.externalID = true;
                    break;
                }
                this.externalID = false;
                this.publicID = true;
            }
        }
        this.space.parse(baseParser);
        baseParser.accept(39);
        this.type = 12;
    }

    public String toString() {
        String string = "<!NOTATION " + this.name;
        string = this.publicID ? string + " PUBLIC " + "\"" + this.pubidLiteral + "\"" : (this.isSYSTEM ? string + " SYSTEM " + "\"" + this.systemLiteral + "\"" : string + " PUBLIC " + "\"" + this.pubidLiteral + "\"" + " \"" + this.systemLiteral + "\"");
        return string + ">";
    }
}

