/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.client;

import com.hazelcast.client.impl.client.CallableClientRequest;
import com.hazelcast.client.impl.client.ClientPortableHook;
import com.hazelcast.client.impl.client.RetryableRequest;
import com.hazelcast.core.DistributedObjectEvent;
import com.hazelcast.core.DistributedObjectListener;
import com.hazelcast.spi.ProxyService;
import com.hazelcast.spi.impl.PortableDistributedObjectEvent;
import java.security.Permission;

public class DistributedObjectListenerRequest
extends CallableClientRequest
implements RetryableRequest {
    public Object call() throws Exception {
        ProxyService proxyService = this.clientEngine.getProxyService();
        String registrationId = proxyService.addProxyListener(new MyDistributedObjectListener());
        this.endpoint.setDistributedObjectListener(registrationId);
        return registrationId;
    }

    @Override
    public String getServiceName() {
        return null;
    }

    @Override
    public int getFactoryId() {
        return ClientPortableHook.ID;
    }

    @Override
    public int getClassId() {
        return 9;
    }

    @Override
    public Permission getRequiredPermission() {
        return null;
    }

    private class MyDistributedObjectListener
    implements DistributedObjectListener {
        private MyDistributedObjectListener() {
        }

        @Override
        public void distributedObjectCreated(DistributedObjectEvent event) {
            this.send(event);
        }

        @Override
        public void distributedObjectDestroyed(DistributedObjectEvent event) {
            this.send(event);
        }

        private void send(DistributedObjectEvent event) {
            if (DistributedObjectListenerRequest.this.endpoint.live()) {
                PortableDistributedObjectEvent portableEvent = new PortableDistributedObjectEvent(event.getEventType(), event.getDistributedObject().getName(), event.getServiceName());
                DistributedObjectListenerRequest.this.endpoint.sendEvent(portableEvent, DistributedObjectListenerRequest.this.getCallId());
            }
        }
    }
}

