/*
 * Decompiled with CFR 0.152.
 */
package pl.mn.communicator.packet.http;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import pl.mn.communicator.IGGConfiguration;
import pl.mn.communicator.packet.http.AbstractTokenRequest;
import pl.mn.communicator.packet.http.CommonRegisterResponse;
import pl.mn.communicator.packet.http.HttpResponse;

public class ChangePasswordRequest
extends AbstractTokenRequest {
    private int m_uin = -1;
    private String m_email = null;
    private String m_oldPassword = null;
    private String m_newPassword = null;

    public ChangePasswordRequest(IGGConfiguration configuration, int uin, String email, String oldPassword, String newPassword, String tokenID, String tokenVal) throws IOException {
        super(configuration, tokenID, tokenVal);
        if (uin < 0) {
            throw new IllegalArgumentException("uin cannot be less than 0");
        }
        if (email == null) {
            throw new NullPointerException("email cannot be null");
        }
        if (oldPassword == null) {
            throw new NullPointerException("oldPassword cannot be null");
        }
        if (newPassword == null) {
            throw new NullPointerException("newPassword cannot be null");
        }
        this.m_uin = uin;
        this.m_email = email;
        this.m_oldPassword = oldPassword;
        this.m_newPassword = newPassword;
    }

    public HttpResponse getResponse() throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(this.m_huc.getInputStream(), "windows-1250"));
        String line = reader.readLine();
        return new CommonRegisterResponse(this.m_uin, line);
    }

    protected String getURL() {
        return this.m_ggconfiguration.getRegistrationURL();
    }

    protected String getRequestBody() throws UnsupportedEncodingException {
        StringBuffer buffer = new StringBuffer();
        buffer.append("fmnumber=");
        buffer.append(this.m_uin);
        buffer.append('&');
        buffer.append("fmpwd=");
        buffer.append(URLEncoder.encode(this.m_oldPassword, "windows-1250"));
        buffer.append('&');
        buffer.append("pwd=");
        buffer.append(URLEncoder.encode(this.m_newPassword, "windows-1250"));
        buffer.append('&');
        buffer.append("email=");
        buffer.append(URLEncoder.encode(this.m_email, "windows-1250"));
        buffer.append('&');
        buffer.append("tokenid=");
        buffer.append(this.getTokenID());
        buffer.append('&');
        buffer.append("tokenval=");
        buffer.append(this.getTokenVal());
        buffer.append('&');
        buffer.append("code=");
        buffer.append(this.getHashCode(this.m_email, this.m_newPassword));
        return buffer.toString();
    }

    protected boolean wannaWrite() {
        return true;
    }
}

