/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.netty.channel.socket.nio;

import java.net.InetSocketAddress;
import java.nio.channels.SelectableChannel;
import java.util.Collection;
import java.util.Iterator;
import java.util.Queue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.channel.AbstractChannel;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelSink;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.socket.nio.AbstractNioWorker;
import org.jboss.netty.channel.socket.nio.NioChannelConfig;
import org.jboss.netty.channel.socket.nio.SocketSendBufferPool;
import org.jboss.netty.util.internal.QueueFactory;
import org.jboss.netty.util.internal.ThreadLocalBoolean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractNioChannel<C extends SelectableChannel>
extends AbstractChannel {
    final AbstractNioWorker worker;
    final Object interestOpsLock = new Object();
    final Object writeLock = new Object();
    final Runnable writeTask = new WriteTask();
    final AtomicBoolean writeTaskInTaskQueue = new AtomicBoolean();
    final Queue<MessageEvent> writeBufferQueue = new WriteRequestQueue();
    final AtomicInteger writeBufferSize = new AtomicInteger();
    final AtomicInteger highWaterMarkCounter = new AtomicInteger();
    MessageEvent currentWriteEvent;
    SocketSendBufferPool.SendBuffer currentWriteBuffer;
    boolean inWriteNowLoop;
    boolean writeSuspended;
    private volatile InetSocketAddress localAddress;
    volatile InetSocketAddress remoteAddress;
    final C channel;

    protected AbstractNioChannel(Integer id, Channel parent, ChannelFactory factory, ChannelPipeline pipeline, ChannelSink sink, AbstractNioWorker worker, C ch) {
        super(id, parent, factory, pipeline, sink);
        this.worker = worker;
        this.channel = ch;
    }

    protected AbstractNioChannel(Channel parent, ChannelFactory factory, ChannelPipeline pipeline, ChannelSink sink, AbstractNioWorker worker, C ch) {
        super(parent, factory, pipeline, sink);
        this.worker = worker;
        this.channel = ch;
    }

    public AbstractNioWorker getWorker() {
        return this.worker;
    }

    @Override
    public InetSocketAddress getLocalAddress() {
        InetSocketAddress localAddress = this.localAddress;
        if (localAddress == null) {
            try {
                this.localAddress = localAddress = this.getLocalSocketAddress();
            }
            catch (Throwable t) {
                return null;
            }
        }
        return localAddress;
    }

    @Override
    public InetSocketAddress getRemoteAddress() {
        InetSocketAddress remoteAddress = this.remoteAddress;
        if (remoteAddress == null) {
            try {
                this.remoteAddress = remoteAddress = this.getRemoteSocketAddress();
            }
            catch (Throwable t) {
                return null;
            }
        }
        return remoteAddress;
    }

    @Override
    public abstract NioChannelConfig getConfig();

    int getRawInterestOps() {
        return super.getInterestOps();
    }

    void setRawInterestOpsNow(int interestOps) {
        super.setInterestOpsNow(interestOps);
    }

    @Override
    public int getInterestOps() {
        int highWaterMark;
        int lowWaterMark;
        if (!this.isOpen()) {
            return 4;
        }
        int interestOps = this.getRawInterestOps();
        int writeBufferSize = this.writeBufferSize.get();
        interestOps = writeBufferSize != 0 ? (this.highWaterMarkCounter.get() > 0 ? (writeBufferSize >= (lowWaterMark = this.getConfig().getWriteBufferLowWaterMark()) ? (interestOps |= 4) : (interestOps &= 0xFFFFFFFB)) : (writeBufferSize >= (highWaterMark = this.getConfig().getWriteBufferHighWaterMark()) ? (interestOps |= 4) : (interestOps &= 0xFFFFFFFB))) : (interestOps &= 0xFFFFFFFB);
        return interestOps;
    }

    @Override
    protected boolean setClosed() {
        return super.setClosed();
    }

    abstract InetSocketAddress getLocalSocketAddress() throws Exception;

    abstract InetSocketAddress getRemoteSocketAddress() throws Exception;

    private final class WriteTask
    implements Runnable {
        WriteTask() {
        }

        public void run() {
            AbstractNioChannel.this.writeTaskInTaskQueue.set(false);
            AbstractNioChannel.this.worker.writeFromTaskLoop(AbstractNioChannel.this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class WriteRequestQueue
    implements BlockingQueue<MessageEvent> {
        private final ThreadLocalBoolean notifying = new ThreadLocalBoolean();
        private final BlockingQueue<MessageEvent> queue = QueueFactory.createQueue(MessageEvent.class);

        @Override
        public MessageEvent remove() {
            return (MessageEvent)this.queue.remove();
        }

        @Override
        public MessageEvent element() {
            return (MessageEvent)this.queue.element();
        }

        @Override
        public MessageEvent peek() {
            return (MessageEvent)this.queue.peek();
        }

        @Override
        public int size() {
            return this.queue.size();
        }

        @Override
        public boolean isEmpty() {
            return this.queue.isEmpty();
        }

        @Override
        public Iterator<MessageEvent> iterator() {
            return this.queue.iterator();
        }

        @Override
        public Object[] toArray() {
            return this.queue.toArray();
        }

        @Override
        public <T> T[] toArray(T[] a) {
            return this.queue.toArray(a);
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            return this.queue.containsAll(c);
        }

        @Override
        public boolean addAll(Collection<? extends MessageEvent> c) {
            return this.queue.addAll(c);
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            return this.queue.removeAll(c);
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            return this.queue.retainAll(c);
        }

        @Override
        public void clear() {
            this.queue.clear();
        }

        @Override
        public boolean add(MessageEvent e) {
            return this.queue.add(e);
        }

        @Override
        public void put(MessageEvent e) throws InterruptedException {
            this.queue.put(e);
        }

        @Override
        public boolean offer(MessageEvent e, long timeout, TimeUnit unit) throws InterruptedException {
            return this.queue.offer(e, timeout, unit);
        }

        @Override
        public MessageEvent take() throws InterruptedException {
            return this.queue.take();
        }

        @Override
        public MessageEvent poll(long timeout, TimeUnit unit) throws InterruptedException {
            return this.queue.poll(timeout, unit);
        }

        @Override
        public int remainingCapacity() {
            return this.queue.remainingCapacity();
        }

        @Override
        public boolean remove(Object o) {
            return this.queue.remove(o);
        }

        @Override
        public boolean contains(Object o) {
            return this.queue.contains(o);
        }

        @Override
        public int drainTo(Collection<? super MessageEvent> c) {
            return this.queue.drainTo(c);
        }

        @Override
        public int drainTo(Collection<? super MessageEvent> c, int maxElements) {
            return this.queue.drainTo(c, maxElements);
        }

        @Override
        public boolean offer(MessageEvent e) {
            int highWaterMark;
            boolean success = this.queue.offer(e);
            assert (success);
            int messageSize = this.getMessageSize(e);
            int newWriteBufferSize = AbstractNioChannel.this.writeBufferSize.addAndGet(messageSize);
            if (newWriteBufferSize >= (highWaterMark = AbstractNioChannel.this.getConfig().getWriteBufferHighWaterMark()) && newWriteBufferSize - messageSize < highWaterMark) {
                AbstractNioChannel.this.highWaterMarkCounter.incrementAndGet();
                if (!((Boolean)this.notifying.get()).booleanValue()) {
                    this.notifying.set(Boolean.TRUE);
                    Channels.fireChannelInterestChanged(AbstractNioChannel.this);
                    this.notifying.set(Boolean.FALSE);
                }
            }
            return true;
        }

        @Override
        public MessageEvent poll() {
            MessageEvent e = (MessageEvent)this.queue.poll();
            if (e != null) {
                int messageSize = this.getMessageSize(e);
                int newWriteBufferSize = AbstractNioChannel.this.writeBufferSize.addAndGet(-messageSize);
                int lowWaterMark = AbstractNioChannel.this.getConfig().getWriteBufferLowWaterMark();
                if ((newWriteBufferSize == 0 || newWriteBufferSize < lowWaterMark) && newWriteBufferSize + messageSize >= lowWaterMark) {
                    AbstractNioChannel.this.highWaterMarkCounter.decrementAndGet();
                    if (AbstractNioChannel.this.isConnected() && !((Boolean)this.notifying.get()).booleanValue()) {
                        this.notifying.set(Boolean.TRUE);
                        Channels.fireChannelInterestChanged(AbstractNioChannel.this);
                        this.notifying.set(Boolean.FALSE);
                    }
                }
            }
            return e;
        }

        private int getMessageSize(MessageEvent e) {
            Object m = e.getMessage();
            if (m instanceof ChannelBuffer) {
                return ((ChannelBuffer)m).readableBytes();
            }
            return 0;
        }
    }
}

