/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.osgi.framework;

import java.util.Comparator;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Map;
import java.util.TreeMap;
import org.jitsi.impl.osgi.framework.BundleImpl;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;

public class ServiceRegistrationImpl
implements ServiceRegistration {
    private static final Comparator<String> CASE_INSENSITIVE_COMPARATOR = new Comparator<String>(){

        @Override
        public int compare(String s1, String s2) {
            return s1.compareToIgnoreCase(s2);
        }
    };
    private static final Map<String, Object> EMPTY_PROPERTIES = ServiceRegistrationImpl.newCaseInsensitiveMapInstance();
    private final BundleImpl bundle;
    private final String[] classNames;
    private final Map<String, Object> properties;
    private Object service;
    private final Long serviceId;
    private final ServiceReferenceImpl serviceReference = new ServiceReferenceImpl();

    public ServiceRegistrationImpl(BundleImpl bundle, long serviceId, String[] classNames, Object service, Dictionary<String, ?> properties) {
        this.bundle = bundle;
        this.serviceId = serviceId;
        this.classNames = classNames;
        this.service = service;
        if (properties == null || properties.isEmpty()) {
            this.properties = EMPTY_PROPERTIES;
        } else {
            Enumeration<String> keys = properties.keys();
            Map<String, Object> thisProperties = ServiceRegistrationImpl.newCaseInsensitiveMapInstance();
            while (keys.hasMoreElements()) {
                String key = keys.nextElement();
                if ("objectClass".equalsIgnoreCase(key) || "service.id".equalsIgnoreCase(key)) continue;
                if (thisProperties.containsKey(key)) {
                    throw new IllegalArgumentException(key);
                }
                thisProperties.put(key, properties.get(key));
            }
            this.properties = thisProperties.isEmpty() ? EMPTY_PROPERTIES : thisProperties;
        }
    }

    public ServiceReferenceImpl getReference() {
        return this.serviceReference;
    }

    public ServiceReference getReference(Class<?> clazz) {
        return this.serviceReference;
    }

    private static Map<String, Object> newCaseInsensitiveMapInstance() {
        return new TreeMap<String, Object>(CASE_INSENSITIVE_COMPARATOR);
    }

    public void setProperties(Dictionary properties) {
    }

    public void unregister() {
        this.bundle.getFramework().unregisterService(this.bundle, this);
    }

    class ServiceReferenceImpl
    implements ServiceReference {
        ServiceReferenceImpl() {
        }

        public int compareTo(Object other) {
            Long thisServiceId = ServiceRegistrationImpl.this.serviceId;
            Long otherServiceId = ((ServiceRegistrationImpl)other).serviceId;
            return otherServiceId.compareTo(thisServiceId);
        }

        public Bundle getBundle() {
            return ServiceRegistrationImpl.this.bundle;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object getProperty(String key) {
            Object value;
            if ("objectClass".equalsIgnoreCase(key)) {
                value = ServiceRegistrationImpl.this.classNames;
            } else if ("service.id".equalsIgnoreCase(key)) {
                value = ServiceRegistrationImpl.this.serviceId;
            } else {
                Map map = ServiceRegistrationImpl.this.properties;
                synchronized (map) {
                    value = ServiceRegistrationImpl.this.properties.get(key);
                }
            }
            return value;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String[] getPropertyKeys() {
            Map map = ServiceRegistrationImpl.this.properties;
            synchronized (map) {
                String[] keys = new String[2 + ServiceRegistrationImpl.this.properties.size()];
                int index = 0;
                keys[index++] = "objectClass";
                keys[index++] = "service.id";
                for (String key : ServiceRegistrationImpl.this.properties.keySet()) {
                    keys[index++] = key;
                }
                return keys;
            }
        }

        Object getService() {
            return ServiceRegistrationImpl.this.service;
        }

        public Bundle[] getUsingBundles() {
            return null;
        }

        public boolean isAssignableTo(Bundle bundle, String className) {
            return false;
        }
    }
}

