/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.provider;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import org.jivesoftware.smack.packet.PacketExtension;
import org.jivesoftware.smack.provider.PacketExtensionProvider;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smackx.packet.DelayInformation;
import org.xmlpull.v1.XmlPullParser;

public class DelayInformationProvider
implements PacketExtensionProvider {
    private static final SimpleDateFormat XEP_0091_UTC_FALLBACK_FORMAT = new SimpleDateFormat("yyyyMd'T'HH:mm:ss");
    private static final SimpleDateFormat XEP_0082_UTC_FORMAT_WITHOUT_MILLIS;
    private static Map<String, DateFormat> formats;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PacketExtension parseExtension(XmlPullParser parser) throws Exception {
        String stampString = parser.getAttributeValue("", "stamp");
        Date stamp = null;
        DateFormat format = null;
        for (String regexp : formats.keySet()) {
            if (!stampString.matches(regexp)) continue;
            try {
                DateFormat dateFormat = format = formats.get(regexp);
                synchronized (dateFormat) {
                    stamp = format.parse(stampString);
                }
            }
            catch (ParseException e) {}
            break;
        }
        if (format == DelayInformation.XEP_0091_UTC_FORMAT && stampString.split("T")[0].length() < 8) {
            stamp = this.handleDateWithMissingLeadingZeros(stampString);
        }
        if (stamp == null) {
            stamp = new Date();
        }
        DelayInformation delayInformation = new DelayInformation(stamp);
        delayInformation.setFrom(parser.getAttributeValue("", "from"));
        String reason = parser.nextText();
        reason = "".equals(reason) ? null : reason;
        delayInformation.setReason(reason);
        return delayInformation;
    }

    private Date handleDateWithMissingLeadingZeros(String stampString) {
        GregorianCalendar now = new GregorianCalendar();
        Calendar xep91 = null;
        Calendar xep91Fallback = null;
        xep91 = this.parseXEP91Date(stampString, DelayInformation.XEP_0091_UTC_FORMAT);
        xep91Fallback = this.parseXEP91Date(stampString, XEP_0091_UTC_FALLBACK_FORMAT);
        List<Calendar> dates = this.filterDatesBefore(now, xep91, xep91Fallback);
        if (!dates.isEmpty()) {
            return this.determineNearestDate(now, dates).getTime();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Calendar parseXEP91Date(String stampString, DateFormat dateFormat) {
        try {
            DateFormat dateFormat2 = dateFormat;
            synchronized (dateFormat2) {
                dateFormat.parse(stampString);
                return dateFormat.getCalendar();
            }
        }
        catch (ParseException e) {
            return null;
        }
    }

    private List<Calendar> filterDatesBefore(Calendar now, Calendar ... dates) {
        ArrayList<Calendar> result = new ArrayList<Calendar>();
        for (Calendar calendar : dates) {
            if (calendar == null || !calendar.before(now)) continue;
            result.add(calendar);
        }
        return result;
    }

    private Calendar determineNearestDate(final Calendar now, List<Calendar> dates) {
        Collections.sort(dates, new Comparator<Calendar>(){

            @Override
            public int compare(Calendar o1, Calendar o2) {
                Long diff1 = new Long(now.getTimeInMillis() - o1.getTimeInMillis());
                Long diff2 = new Long(now.getTimeInMillis() - o2.getTimeInMillis());
                return diff1.compareTo(diff2);
            }
        });
        return dates.get(0);
    }

    static {
        XEP_0091_UTC_FALLBACK_FORMAT.setTimeZone(TimeZone.getTimeZone("UTC"));
        XEP_0082_UTC_FORMAT_WITHOUT_MILLIS = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        XEP_0082_UTC_FORMAT_WITHOUT_MILLIS.setTimeZone(TimeZone.getTimeZone("UTC"));
        formats = new HashMap<String, DateFormat>();
        formats.put("^\\d+T\\d+:\\d+:\\d+$", DelayInformation.XEP_0091_UTC_FORMAT);
        formats.put("^\\d+-\\d+-\\d+T\\d+:\\d+:\\d+\\.\\d+Z$", StringUtils.XEP_0082_UTC_FORMAT);
        formats.put("^\\d+-\\d+-\\d+T\\d+:\\d+:\\d+Z$", XEP_0082_UTC_FORMAT_WITHOUT_MILLIS);
    }
}

