/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.rtp;

import java.lang.ref.WeakReference;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import javax.media.Buffer;
import javax.media.Format;
import javax.media.control.BufferControl;
import javax.media.control.JitterBufferControl;
import javax.media.format.AudioFormat;
import javax.media.format.VideoFormat;
import javax.media.protocol.BufferTransferHandler;
import javax.media.protocol.ContentDescriptor;
import javax.media.protocol.PushBufferStream;
import net.sf.fmj.media.Log;
import net.sf.fmj.media.protocol.BasicSourceStream;
import net.sf.fmj.media.protocol.BufferListener;
import net.sf.fmj.media.protocol.rtp.DataSource;
import net.sf.fmj.media.rtp.AudioJitterBufferBehaviour;
import net.sf.fmj.media.rtp.BasicJitterBufferBehaviour;
import net.sf.fmj.media.rtp.BufferControlImpl;
import net.sf.fmj.media.rtp.JitterBuffer;
import net.sf.fmj.media.rtp.JitterBufferBehaviour;
import net.sf.fmj.media.rtp.JitterBufferStats;
import net.sf.fmj.media.rtp.RTPRawReceiver;
import net.sf.fmj.media.rtp.VideoJitterBufferBehaviour;
import net.sf.fmj.media.rtp.util.RTPMediaThread;

public class RTPSourceStream
extends BasicSourceStream
implements PushBufferStream {
    private static final long WAIT_TIMEOUT = 100L;
    private BufferControlImpl bc;
    private JitterBufferBehaviour behaviour;
    private boolean bufferWhenStopped = true;
    private boolean closed = false;
    private boolean closing = false;
    final DataSource datasource;
    private Format format;
    private long lastSeqRecv = 0x7FFFFFFFFFFFFFFEL;
    private long lastSeqSent = 0x7FFFFFFFFFFFFFFEL;
    final JitterBuffer q;
    private final Condition qCondition;
    private final Lock qLock;
    private boolean started = false;
    private final Object startSyncRoot = new Object();
    final JitterBufferStats stats;
    private Thread thread;
    private long transferDataReason;
    private BufferTransferHandler transferHandler;

    public RTPSourceStream(DataSource dataSource) {
        dataSource.setSourceStream(this);
        this.datasource = dataSource;
        this.q = new JitterBuffer(4);
        this.qCondition = this.q.condition;
        this.qLock = this.q.lock;
        this.stats = new JitterBufferStats(this);
        this.setBehaviour(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Buffer buffer, boolean bl, RTPRawReceiver rTPRawReceiver) {
        if (!this.started && !this.bufferWhenStopped) {
            return;
        }
        long l = buffer.getSequenceNumber();
        this.qLock.lock();
        try {
            if (this.lastSeqRecv - l > 256L) {
                Log.info("Resetting queue, last seq added: " + this.lastSeqRecv + ", current seq: " + l);
                this.reset();
                this.lastSeqRecv = l;
            }
            this.stats.updateMaxSizeReached();
            this.stats.updateSizePerPacket(buffer);
            if (!this.behaviour.preAdd(buffer, rTPRawReceiver)) {
                return;
            }
            this.stats.incrementNbAdd();
            this.lastSeqRecv = l;
            boolean bl2 = false;
            if (this.q.noMoreFree()) {
                this.stats.incrementDiscardedFull();
                long l2 = this.q.getFirstSeq();
                if (l2 != 0x7FFFFFFFFFFFFFFEL && l < l2) {
                    return;
                }
                this.behaviour.dropPkt();
            }
            if (this.q.getFreeCount() <= 1) {
                bl2 = true;
            }
            Buffer buffer2 = this.q.getFree();
            boolean bl3 = false;
            try {
                byte[] byArray = (byte[])buffer.getData();
                byte[] byArray2 = (byte[])buffer2.getData();
                if (byArray2 == null || byArray2.length < byArray.length) {
                    byArray2 = new byte[byArray.length];
                }
                System.arraycopy(byArray, buffer.getOffset(), byArray2, buffer.getOffset(), buffer.getLength());
                buffer2.copy(buffer);
                buffer2.setData(byArray2);
                if (bl2) {
                    buffer2.setFlags(buffer2.getFlags() | 0x2000 | 0x20);
                } else {
                    buffer2.setFlags(buffer2.getFlags() | 0x20);
                }
                this.q.addPkt(buffer2);
                bl3 = true;
            }
            finally {
                if (!bl3) {
                    this.q.returnFree(buffer2);
                }
            }
            ++this.transferDataReason;
            if (!this.behaviour.willReadBlock()) {
                this.qCondition.signalAll();
            }
        }
        finally {
            this.qLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        block18: {
            Object object = this.startSyncRoot;
            synchronized (object) {
                if (this.closing) {
                    return;
                }
                this.closing = true;
                this.thread = null;
                this.startSyncRoot.notifyAll();
            }
            try {
                if (this.closed) break block18;
                this.closed = true;
                this.stats.printStats();
                this.stop();
                if (this.qLock.tryLock()) {
                    try {
                        this.qCondition.signalAll();
                    }
                    finally {
                        this.qLock.unlock();
                    }
                }
                if (this.bc != null) {
                    this.bc.removeSourceStream(this);
                }
            }
            finally {
                object = this.startSyncRoot;
                synchronized (object) {
                    this.closing = false;
                    this.startSyncRoot.notifyAll();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect() {
        Object object = this.startSyncRoot;
        synchronized (object) {
            this.waitWhileClosing();
            this.closed = false;
        }
    }

    JitterBufferBehaviour getBehaviour() {
        return this.behaviour;
    }

    BufferControlImpl getBufferControl() {
        return this.bc;
    }

    public Object getControl(String string) {
        return JitterBufferControl.class.getName().equals(string) ? this.stats : super.getControl(string);
    }

    public Object[] getControls() {
        Object[] objectArray = super.getControls();
        Object[] objectArray2 = new Object[objectArray.length + 1];
        System.arraycopy(objectArray, 0, objectArray2, 0, objectArray.length);
        objectArray2[objectArray.length] = this.stats;
        return objectArray2;
    }

    public Format getFormat() {
        return this.format;
    }

    long getLastReadSequenceNumber() {
        return this.lastSeqSent;
    }

    public void prebuffer() {
    }

    public void read(Buffer buffer) {
        this.qLock.lock();
        try {
            try {
                this.behaviour.read(buffer);
                if (!buffer.isDiscard()) {
                    this.lastSeqSent = buffer.getSequenceNumber();
                }
            }
            finally {
                if (!buffer.isDiscard()) {
                    ++this.transferDataReason;
                    this.qCondition.signalAll();
                }
            }
        }
        finally {
            this.qLock.unlock();
        }
    }

    public void reset() {
        this.qLock.lock();
        try {
            this.stats.incrementNbReset();
            this.resetQ();
            this.behaviour.reset();
            this.lastSeqSent = 0x7FFFFFFFFFFFFFFEL;
        }
        finally {
            this.qLock.unlock();
        }
    }

    public void resetQ() {
        Log.comment("Resetting the RTP packet queue");
        this.qLock.lock();
        try {
            while (this.q.fillNotEmpty()) {
                this.behaviour.dropPkt();
                this.stats.incrementDiscardedReset();
            }
            this.qCondition.signalAll();
        }
        finally {
            this.qLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean runInThread(TransferDataRunnable transferDataRunnable) {
        Object object;
        block19: {
            object = this.startSyncRoot;
            synchronized (object) {
                if (!Thread.currentThread().equals(this.thread) || this.closing || this.closed) {
                    return false;
                }
                if (!this.started) {
                    try {
                        this.startSyncRoot.wait(100L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    return true;
                }
            }
            object = null;
            this.qLock.lock();
            try {
                boolean bl;
                if (this.behaviour.willReadBlock()) {
                    bl = true;
                } else if (transferDataRunnable.transferDataReason == this.transferDataReason) {
                    bl = true;
                } else {
                    object = this.transferHandler;
                    if (object == null) {
                        bl = true;
                    } else {
                        bl = false;
                        transferDataRunnable.transferDataReason = this.transferDataReason;
                    }
                }
                if (!bl) break block19;
                try {
                    this.qCondition.await(100L, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                boolean bl2 = true;
                return bl2;
            }
            finally {
                this.qLock.unlock();
            }
        }
        if (object != null) {
            object.transferData(this);
        }
        return true;
    }

    private void setBehaviour(JitterBufferBehaviour jitterBufferBehaviour) {
        if (jitterBufferBehaviour == null) {
            if (this.behaviour instanceof BasicJitterBufferBehaviour) {
                return;
            }
            jitterBufferBehaviour = new BasicJitterBufferBehaviour(this);
        }
        this.behaviour = jitterBufferBehaviour;
    }

    public void setBufferControl(BufferControl bufferControl) {
        this.bc = (BufferControlImpl)bufferControl;
        this.updateBuffer(this.bc.getBufferLength());
        this.updateThreshold(this.bc.getMinimumThreshold());
    }

    public void setBufferListener(BufferListener bufferListener) {
    }

    public void setBufferWhenStopped(boolean bl) {
        this.bufferWhenStopped = bl;
    }

    void setContentDescriptor(String string) {
        this.contentDescriptor = new ContentDescriptor(string);
    }

    protected void setFormat(Format format) {
        if (this.format != format) {
            this.format = format;
            BasicJitterBufferBehaviour basicJitterBufferBehaviour = this.format instanceof AudioFormat ? new AudioJitterBufferBehaviour(this) : (this.format instanceof VideoFormat ? new VideoJitterBufferBehaviour(this) : null);
            this.setBehaviour(basicJitterBufferBehaviour);
        }
    }

    public void setTransferHandler(BufferTransferHandler bufferTransferHandler) {
        this.transferHandler = bufferTransferHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        Log.info("Starting RTPSourceStream.");
        Object object = this.startSyncRoot;
        synchronized (object) {
            this.started = true;
            this.startThread();
            this.startSyncRoot.notifyAll();
        }
        if (this.qLock.tryLock()) {
            try {
                this.qCondition.signalAll();
            }
            finally {
                this.qLock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startThread() {
        Object object = this.startSyncRoot;
        synchronized (object) {
            this.waitWhileClosing();
            if (this.thread == null && !this.closed) {
                RTPMediaThread rTPMediaThread = new RTPMediaThread(new TransferDataRunnable(this), RTPSourceStream.class.getName());
                rTPMediaThread.setDaemon(true);
                rTPMediaThread.useControlPriority();
                boolean bl = false;
                this.thread = rTPMediaThread;
                try {
                    rTPMediaThread.start();
                    bl = true;
                }
                finally {
                    if (!bl && rTPMediaThread.equals(this.thread)) {
                        this.thread = null;
                    }
                }
            }
            this.startSyncRoot.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Log.info("Stopping RTPSourceStream.");
        Object object = this.startSyncRoot;
        synchronized (object) {
            this.started = false;
            this.startSyncRoot.notifyAll();
            if (!this.bufferWhenStopped) {
                this.reset();
            }
        }
        if (this.qLock.tryLock()) {
            try {
                this.qCondition.signalAll();
            }
            finally {
                this.qLock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void threadExited(TransferDataRunnable transferDataRunnable) {
        Object object = this.startSyncRoot;
        synchronized (object) {
            if (Thread.currentThread().equals(this.thread)) {
                this.thread = null;
                this.startSyncRoot.notifyAll();
            }
        }
    }

    public long updateBuffer(long l) {
        return l;
    }

    public long updateThreshold(long l) {
        return l;
    }

    private void waitWhileClosing() {
        boolean bl = false;
        while (this.closing) {
            try {
                this.startSyncRoot.wait();
            }
            catch (InterruptedException interruptedException) {
                bl = true;
            }
        }
        if (bl) {
            Thread.currentThread().interrupt();
        }
    }

    private static class TransferDataRunnable
    implements Runnable {
        private static final boolean WEAK_REFERENCE = false;
        private final RTPSourceStream owner;
        private long transferDataReason;
        private final WeakReference<RTPSourceStream> weakReference;

        public TransferDataRunnable(RTPSourceStream rTPSourceStream) {
            this.owner = rTPSourceStream;
            this.weakReference = null;
        }

        private RTPSourceStream getOwner() {
            return this.owner;
        }

        public void run() {
            RTPSourceStream rTPSourceStream;
            try {
                while ((rTPSourceStream = this.getOwner()) != null) {
                    if (rTPSourceStream.runInThread(this)) continue;
                    break;
                }
            }
            finally {
                rTPSourceStream = this.getOwner();
                if (rTPSourceStream != null) {
                    rTPSourceStream.threadExited(this);
                }
            }
        }
    }
}

