/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.rtp;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import net.sf.fmj.media.rtp.RTCPAPPPacket;
import net.sf.fmj.media.rtp.RTCPBYEPacket;
import net.sf.fmj.media.rtp.RTCPCompoundPacket;
import net.sf.fmj.media.rtp.RTCPPacket;
import net.sf.fmj.media.rtp.RTCPPacketParserListener;
import net.sf.fmj.media.rtp.RTCPRRPacket;
import net.sf.fmj.media.rtp.RTCPReportBlock;
import net.sf.fmj.media.rtp.RTCPSDES;
import net.sf.fmj.media.rtp.RTCPSDESItem;
import net.sf.fmj.media.rtp.RTCPSDESPacket;
import net.sf.fmj.media.rtp.RTCPSRPacket;
import net.sf.fmj.media.rtp.util.BadFormatException;
import net.sf.fmj.media.rtp.util.BadVersionException;
import net.sf.fmj.media.rtp.util.Packet;

public class RTCPPacketParser {
    private final List<RTCPPacketParserListener> listeners = new ArrayList<RTCPPacketParserListener>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRTCPPacketParserListener(RTCPPacketParserListener rTCPPacketParserListener) {
        if (rTCPPacketParserListener == null) {
            throw new NullPointerException("listener");
        }
        List<RTCPPacketParserListener> list = this.listeners;
        synchronized (list) {
            if (!this.listeners.contains(rTCPPacketParserListener)) {
                this.listeners.add(rTCPPacketParserListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onEnterSenderReport() {
        List<RTCPPacketParserListener> list = this.listeners;
        synchronized (list) {
            for (RTCPPacketParserListener rTCPPacketParserListener : this.listeners) {
                rTCPPacketParserListener.enterSenderReport();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onMalformedEndOfParticipation() {
        List<RTCPPacketParserListener> list = this.listeners;
        synchronized (list) {
            for (RTCPPacketParserListener rTCPPacketParserListener : this.listeners) {
                rTCPPacketParserListener.malformedEndOfParticipation();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onMalformedReceiverReport() {
        List<RTCPPacketParserListener> list = this.listeners;
        synchronized (list) {
            for (RTCPPacketParserListener rTCPPacketParserListener : this.listeners) {
                rTCPPacketParserListener.malformedReceiverReport();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onMalformedSenderReport() {
        List<RTCPPacketParserListener> list = this.listeners;
        synchronized (list) {
            for (RTCPPacketParserListener rTCPPacketParserListener : this.listeners) {
                rTCPPacketParserListener.malformedSenderReport();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onMalformedSourceDescription() {
        List<RTCPPacketParserListener> list = this.listeners;
        synchronized (list) {
            for (RTCPPacketParserListener rTCPPacketParserListener : this.listeners) {
                rTCPPacketParserListener.malformedSourceDescription();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onPayloadUknownType() {
        List<RTCPPacketParserListener> list = this.listeners;
        synchronized (list) {
            for (RTCPPacketParserListener rTCPPacketParserListener : this.listeners) {
                rTCPPacketParserListener.uknownPayloadType();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onVisitSenderReport(RTCPSRPacket rTCPSRPacket) {
        List<RTCPPacketParserListener> list = this.listeners;
        synchronized (list) {
            for (RTCPPacketParserListener rTCPPacketParserListener : this.listeners) {
                rTCPPacketParserListener.visitSendeReport(rTCPSRPacket);
            }
        }
    }

    public RTCPPacket parse(Packet packet) throws BadFormatException {
        RTCPCompoundPacket rTCPCompoundPacket = new RTCPCompoundPacket(packet);
        Vector<RTCPSDESPacket> vector = new Vector<RTCPSDESPacket>(2);
        DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(rTCPCompoundPacket.data, rTCPCompoundPacket.offset, rTCPCompoundPacket.length));
        try {
            int n;
            for (int i = 0; i < rTCPCompoundPacket.length; i += n) {
                RTCPPacket rTCPPacket;
                int n2 = dataInputStream.readUnsignedByte();
                if ((n2 & 0xC0) != 128) {
                    throw new BadVersionException("version must be 2. (base.length " + rTCPCompoundPacket.length + ", base.offset " + rTCPCompoundPacket.offset + ", firstbyte 0x" + Integer.toHexString(n2) + ", offset " + i + ")");
                }
                int n3 = dataInputStream.readUnsignedByte();
                n = dataInputStream.readUnsignedShort();
                if (i + (n = n + 1 << 2) > rTCPCompoundPacket.length) {
                    throw new BadFormatException("Packet length less than actual packet length");
                }
                int n4 = 0;
                if (i + n == rTCPCompoundPacket.length) {
                    if ((n2 & 0x20) != 0 && (n4 = rTCPCompoundPacket.data[rTCPCompoundPacket.offset + rTCPCompoundPacket.length - 1] & 0xFF) == 0) {
                        throw new BadFormatException();
                    }
                } else if ((n2 & 0x20) != 0) {
                    throw new BadFormatException("No padding found.");
                }
                int n5 = n - n4;
                n2 &= 0x1F;
                switch (n3) {
                    case 200: {
                        this.onEnterSenderReport();
                        if (n5 != 28 + 24 * n2) {
                            this.onMalformedSenderReport();
                            System.out.println("bad format.");
                            throw new BadFormatException("inlength != 28 + 24 * firstbyte");
                        }
                        RTCPSRPacket rTCPSRPacket = new RTCPSRPacket(rTCPCompoundPacket);
                        rTCPPacket = rTCPSRPacket;
                        rTCPSRPacket.ssrc = dataInputStream.readInt();
                        rTCPSRPacket.ntptimestampmsw = (long)dataInputStream.readInt() & 0xFFFFFFFFL;
                        rTCPSRPacket.ntptimestamplsw = (long)dataInputStream.readInt() & 0xFFFFFFFFL;
                        rTCPSRPacket.rtptimestamp = (long)dataInputStream.readInt() & 0xFFFFFFFFL;
                        rTCPSRPacket.packetcount = (long)dataInputStream.readInt() & 0xFFFFFFFFL;
                        rTCPSRPacket.octetcount = (long)dataInputStream.readInt() & 0xFFFFFFFFL;
                        rTCPSRPacket.reports = new RTCPReportBlock[n2];
                        this.onVisitSenderReport(rTCPSRPacket);
                        this.readRTCPReportBlock(dataInputStream, rTCPSRPacket.reports);
                        break;
                    }
                    case 201: {
                        if (n5 != 8 + 24 * n2) {
                            this.onMalformedReceiverReport();
                            throw new BadFormatException("inlength != 8 + 24 * firstbyte");
                        }
                        RTCPRRPacket rTCPRRPacket = new RTCPRRPacket(rTCPCompoundPacket);
                        rTCPPacket = rTCPRRPacket;
                        rTCPRRPacket.ssrc = dataInputStream.readInt();
                        rTCPRRPacket.reports = new RTCPReportBlock[n2];
                        this.readRTCPReportBlock(dataInputStream, rTCPRRPacket.reports);
                        break;
                    }
                    case 202: {
                        Object object;
                        RTCPSDESPacket rTCPSDESPacket;
                        rTCPPacket = rTCPSDESPacket = new RTCPSDESPacket(rTCPCompoundPacket);
                        rTCPSDESPacket.sdes = new RTCPSDES[n2];
                        int n6 = 4;
                        for (int j = 0; j < rTCPSDESPacket.sdes.length; ++j) {
                            int n7;
                            RTCPSDES rTCPSDES;
                            rTCPSDESPacket.sdes[j] = rTCPSDES = new RTCPSDES();
                            rTCPSDES.ssrc = dataInputStream.readInt();
                            n6 += 5;
                            object = new Vector();
                            boolean bl = false;
                            while ((n7 = dataInputStream.readUnsignedByte()) != 0) {
                                if (n7 < 1 || n7 > 8) {
                                    this.onMalformedSourceDescription();
                                    throw new BadFormatException("j < 1 || j > 8");
                                }
                                if (n7 == 1) {
                                    bl = true;
                                }
                                RTCPSDESItem rTCPSDESItem = new RTCPSDESItem();
                                ((Vector)object).addElement(rTCPSDESItem);
                                rTCPSDESItem.type = n7;
                                int n8 = dataInputStream.readUnsignedByte();
                                rTCPSDESItem.data = new byte[n8];
                                dataInputStream.readFully(rTCPSDESItem.data);
                                n6 += 2 + n8;
                            }
                            if (!bl) {
                                this.onMalformedSourceDescription();
                                throw new BadFormatException("!gotcname");
                            }
                            rTCPSDES.items = new RTCPSDESItem[((Vector)object).size()];
                            ((Vector)object).copyInto(rTCPSDES.items);
                            if ((n6 & 3) == 0) continue;
                            dataInputStream.skip(4 - (n6 & 3));
                            n6 = n6 + 3 & 0xFFFFFFFC;
                        }
                        if (n5 == n6) break;
                        this.onMalformedSourceDescription();
                        throw new BadFormatException("inlength != sdesoff");
                    }
                    case 203: {
                        int n9;
                        RTCPBYEPacket rTCPBYEPacket = new RTCPBYEPacket(rTCPCompoundPacket);
                        rTCPPacket = rTCPBYEPacket;
                        rTCPBYEPacket.ssrc = new int[n2];
                        for (n9 = 0; n9 < rTCPBYEPacket.ssrc.length; ++n9) {
                            rTCPBYEPacket.ssrc[n9] = dataInputStream.readInt();
                        }
                        if (n5 > 4 + 4 * n2) {
                            n9 = dataInputStream.readUnsignedByte();
                            rTCPBYEPacket.reason = new byte[n9];
                            ++n9;
                        } else {
                            n9 = 0;
                            rTCPBYEPacket.reason = new byte[0];
                        }
                        n9 = n9 + 3 & 0xFFFFFFFC;
                        if (n5 != 4 + 4 * n2 + n9) {
                            this.onMalformedEndOfParticipation();
                            throw new BadFormatException("inlength != 4 + 4 * firstbyte + reasonlen");
                        }
                        dataInputStream.readFully(rTCPBYEPacket.reason);
                        dataInputStream.skip(n9 - rTCPBYEPacket.reason.length);
                        break;
                    }
                    case 204: {
                        if (n5 < 12) {
                            throw new BadFormatException("inlength < 12");
                        }
                        Object object = new RTCPAPPPacket(rTCPCompoundPacket);
                        rTCPPacket = object;
                        ((RTCPAPPPacket)object).ssrc = dataInputStream.readInt();
                        ((RTCPAPPPacket)object).name = dataInputStream.readInt();
                        ((RTCPAPPPacket)object).subtype = n2;
                        ((RTCPAPPPacket)object).data = new byte[n5 - 12];
                        dataInputStream.readFully(((RTCPAPPPacket)object).data);
                        dataInputStream.skip(n5 - 12 - ((RTCPAPPPacket)object).data.length);
                        break;
                    }
                    default: {
                        rTCPPacket = this.parse(rTCPCompoundPacket, n2, n3, n, dataInputStream);
                        if (rTCPPacket != null) break;
                        this.onPayloadUknownType();
                        throw new BadFormatException("p == null");
                    }
                }
                rTCPPacket.offset = i;
                rTCPPacket.length = n;
                vector.addElement((RTCPSDESPacket)rTCPPacket);
                dataInputStream.skipBytes(n4);
            }
        }
        catch (EOFException eOFException) {
            throw new BadFormatException("Unexpected end of RTCP packet");
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("Impossible Exception");
        }
        rTCPCompoundPacket.packets = new RTCPPacket[vector.size()];
        vector.copyInto(rTCPCompoundPacket.packets);
        return rTCPCompoundPacket;
    }

    protected RTCPPacket parse(RTCPCompoundPacket rTCPCompoundPacket, int n, int n2, int n3, DataInputStream dataInputStream) throws BadFormatException, IOException {
        this.onPayloadUknownType();
        throw new BadFormatException("Uknown payload type");
    }

    private void readRTCPReportBlock(DataInputStream dataInputStream, RTCPReportBlock[] rTCPReportBlockArray) throws IOException {
        for (int i = 0; i < rTCPReportBlockArray.length; ++i) {
            RTCPReportBlock rTCPReportBlock;
            rTCPReportBlockArray[i] = rTCPReportBlock = new RTCPReportBlock();
            rTCPReportBlock.ssrc = dataInputStream.readInt();
            long l = dataInputStream.readInt();
            rTCPReportBlock.fractionlost = (int)((l &= 0xFFFFFFFFL) >> 24);
            rTCPReportBlock.packetslost = (int)(l & 0xFFFFFFL);
            rTCPReportBlock.lastseq = (long)dataInputStream.readInt() & 0xFFFFFFFFL;
            rTCPReportBlock.jitter = dataInputStream.readInt();
            rTCPReportBlock.lsr = (long)dataInputStream.readInt() & 0xFFFFFFFFL;
            rTCPReportBlock.dlsr = (long)dataInputStream.readInt() & 0xFFFFFFFFL;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRTCPPacketParserListener(RTCPPacketParserListener rTCPPacketParserListener) {
        if (rTCPPacketParserListener != null) {
            List<RTCPPacketParserListener> list = this.listeners;
            synchronized (list) {
                this.listeners.remove(rTCPPacketParserListener);
            }
        }
    }
}

