/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.rtp;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.net.DatagramPacket;

public class RTCPHeader {
    public static final int VERSION = 2;
    public static final int SDES_SKIP = 8;
    public static final int SDES_CNAME = 1;
    public static final int SDES_NAME = 2;
    public static final int SDES_EMAIL = 3;
    public static final int SDES_PHONE = 4;
    public static final int SDES_LOC = 5;
    public static final int SDES_TOOL = 6;
    public static final int SDES_NOTE = 7;
    public static final int SIZE = 8;
    private static final int VERSION_MASK = 49152;
    private static final int VERSION_SHIFT = 14;
    private static final int PADDING_MASK = 8192;
    private static final int PADDING_SHIFT = 13;
    private static final int RCOUNT_MASK = 7936;
    private static final int RCOUNT_SHIFT = 8;
    private static final int TYPE_MASK = 255;
    private static final int TYPE_SHIFT = 0;
    private int flags;
    private int length;
    private long ssrc;

    public RTCPHeader(byte[] byArray, int n, int n2) throws IOException {
        DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray, n, n2));
        this.flags = dataInputStream.readUnsignedShort();
        this.length = dataInputStream.readUnsignedShort();
        this.ssrc = (long)dataInputStream.readInt() & 0xFFFFFFFFL;
        if (this.getVersion() != 2) {
            throw new IOException("Invalid RTCP Version");
        }
        if (this.getLength() > n2) {
            throw new IOException("Invalid Length");
        }
    }

    public RTCPHeader(DatagramPacket datagramPacket) throws IOException {
        this(datagramPacket.getData(), datagramPacket.getOffset(), datagramPacket.getLength());
    }

    public int getFlags() {
        return this.flags;
    }

    public int getLength() {
        return this.length;
    }

    public short getPacketType() {
        return (short)((this.getFlags() & 0xFF) >> 0);
    }

    public short getPadding() {
        return (short)((this.getFlags() & 0x2000) >> 13);
    }

    public short getReceptionCount() {
        return (short)((this.getFlags() & 0x1F00) >> 8);
    }

    public long getSsrc() {
        return this.ssrc;
    }

    public short getVersion() {
        return (short)((this.getFlags() & 0xC000) >> 14);
    }

    public void print() {
        System.err.println(this.getVersion() + "|" + this.getPadding() + "|" + this.getReceptionCount() + "|" + this.getPacketType() + "|" + this.getLength() + "|" + this.getSsrc());
    }
}

