/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jml.impl;

import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import net.sf.jml.Email;
import net.sf.jml.MsnContact;
import net.sf.jml.MsnFileTransfer;
import net.sf.jml.MsnMessenger;
import net.sf.jml.MsnSwitchboard;
import net.sf.jml.message.MsnMimeMessage;
import net.sf.jml.protocol.MsnOutgoingMessage;

public abstract class AbstractSwitchboard
implements MsnSwitchboard {
    private final MsnMessenger messenger;
    private Object attachment;
    private final Map<MsnContact, Email> contacts = new LinkedHashMap<MsnContact, Email>();
    private final Set<MsnFileTransfer> fileTransfers = new LinkedHashSet<MsnFileTransfer>();

    public AbstractSwitchboard(MsnMessenger msnMessenger) {
        this.messenger = msnMessenger;
    }

    public MsnMessenger getMessenger() {
        return this.messenger;
    }

    public Object getAttachment() {
        return this.attachment;
    }

    public void setAttachment(Object object) {
        this.attachment = object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MsnContact[] getAllContacts() {
        Map<MsnContact, Email> map = this.contacts;
        synchronized (map) {
            MsnContact[] msnContactArray = new MsnContact[this.contacts.size()];
            this.contacts.keySet().toArray(msnContactArray);
            return msnContactArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addContact(MsnContact msnContact) {
        if (msnContact != null && msnContact.getContactList().getMessenger() == this.getMessenger()) {
            Map<MsnContact, Email> map = this.contacts;
            synchronized (map) {
                this.contacts.put(msnContact, msnContact.getEmail());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeContact(MsnContact msnContact) {
        Map<MsnContact, Email> map = this.contacts;
        synchronized (map) {
            this.contacts.remove(msnContact);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containContact(MsnContact msnContact) {
        Map<MsnContact, Email> map = this.contacts;
        synchronized (map) {
            return this.contacts.keySet().contains(msnContact);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containContact(Email email) {
        Map<MsnContact, Email> map = this.contacts;
        synchronized (map) {
            return this.contacts.values().contains(email);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MsnFileTransfer[] getActiveFileTransfers() {
        Set<MsnFileTransfer> set = this.fileTransfers;
        synchronized (set) {
            MsnFileTransfer[] msnFileTransferArray = new MsnFileTransfer[this.fileTransfers.size()];
            this.fileTransfers.toArray(msnFileTransferArray);
            return msnFileTransferArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFileTransfer(MsnFileTransfer msnFileTransfer) {
        Set<MsnFileTransfer> set = this.fileTransfers;
        synchronized (set) {
            this.fileTransfers.add(msnFileTransfer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFileTransfer(MsnFileTransfer msnFileTransfer) {
        Set<MsnFileTransfer> set = this.fileTransfers;
        synchronized (set) {
            this.fileTransfers.remove(msnFileTransfer);
        }
    }

    public void send(MsnOutgoingMessage msnOutgoingMessage) {
        this.send(msnOutgoingMessage, false);
    }

    public void sendMessage(MsnMimeMessage msnMimeMessage) {
        this.sendMessage(msnMimeMessage, false);
    }
}

