/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joustsim.trust;

import java.math.BigInteger;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPublicKey;
import net.kano.joscar.DefensiveTools;
import net.kano.joustsim.trust.CertificateHolder;

public class DefaultCertificateHolder
implements CertificateHolder {
    private final X509Certificate certificate;
    private final BigInteger mod;
    private final BigInteger exp;

    public DefaultCertificateHolder(X509Certificate x509Certificate) {
        DefensiveTools.checkNull((Object)x509Certificate, (String)"cert");
        PublicKey publicKey = x509Certificate.getPublicKey();
        if (!(publicKey instanceof RSAPublicKey)) {
            throw new IllegalArgumentException();
        }
        this.certificate = x509Certificate;
        RSAPublicKey rSAPublicKey = (RSAPublicKey)publicKey;
        this.mod = rSAPublicKey.getModulus();
        if (this.mod == null) {
            throw new IllegalArgumentException("modulus of key is null");
        }
        this.exp = rSAPublicKey.getPublicExponent();
        if (this.exp == null) {
            throw new IllegalArgumentException("exponent of key is null");
        }
    }

    public final X509Certificate getCertificate() {
        return this.certificate;
    }

    public final int hashCode() {
        return this.mod.hashCode() ^ this.exp.hashCode();
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof CertificateHolder)) {
            return false;
        }
        DefaultCertificateHolder defaultCertificateHolder = (DefaultCertificateHolder)object;
        return defaultCertificateHolder.mod.equals(this.mod) && defaultCertificateHolder.exp.equals(this.exp);
    }
}

