/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joustsim.oscar;

import java.util.logging.Logger;
import net.kano.joscar.CopyOnWriteArrayList;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.net.ClientConn;
import net.kano.joustsim.oscar.AimConnection;
import net.kano.joustsim.oscar.AimConnectionProperties;
import net.kano.joustsim.oscar.AuthorizingStateInfo;
import net.kano.joustsim.oscar.ConnectingStateInfo;
import net.kano.joustsim.oscar.ConnectionFailedStateInfo;
import net.kano.joustsim.oscar.DisconnectedStateInfo;
import net.kano.joustsim.oscar.LoginFailureStateInfo;
import net.kano.joustsim.oscar.NotConnectedStateInfo;
import net.kano.joustsim.oscar.OnlineStateInfo;
import net.kano.joustsim.oscar.SigningOnStateInfo;
import net.kano.joustsim.oscar.State;
import net.kano.joustsim.oscar.StateEvent;
import net.kano.joustsim.oscar.StateInfo;
import net.kano.joustsim.oscar.StateListener;
import net.kano.joustsim.oscar.oscar.BasicConnection;
import net.kano.joustsim.oscar.oscar.LoginConnection;
import net.kano.joustsim.oscar.oscar.LoginServiceListener;
import net.kano.joustsim.oscar.oscar.OscarConnListener;
import net.kano.joustsim.oscar.oscar.OscarConnStateEvent;
import net.kano.joustsim.oscar.oscar.OscarConnection;
import net.kano.joustsim.oscar.oscar.loginstatus.LoginFailureInfo;
import net.kano.joustsim.oscar.oscar.loginstatus.LoginSuccessInfo;
import net.kano.joustsim.oscar.oscar.service.Service;
import net.kano.joustsim.oscar.oscar.service.ServiceFactory;
import net.kano.joustsim.oscar.oscar.service.bos.MainBosService;
import net.kano.joustsim.oscar.oscar.service.buddy.BuddyService;
import net.kano.joustsim.oscar.oscar.service.icbm.IcbmService;
import net.kano.joustsim.oscar.oscar.service.info.InfoService;
import net.kano.joustsim.oscar.oscar.service.login.LoginService;
import net.kano.joustsim.oscar.oscar.service.ssi.SsiService;

public class ConnectionManager {
    private static final Logger LOGGER = Logger.getLogger(ConnectionManager.class.getName());
    private boolean triedConnecting = false;
    private State state = State.NOTCONNECTED;
    private StateInfo stateInfo = NotConnectedStateInfo.getInstance();
    private boolean wantedDisconnect = false;
    private CopyOnWriteArrayList<StateListener> stateListeners = new CopyOnWriteArrayList();
    private final LoginConnection loginConn;
    private BasicConnection mainConn = null;
    private final AimConnection aimConnection;
    private String password;

    public ConnectionManager(AimConnection aimConnection, AimConnectionProperties props) {
        this.aimConnection = aimConnection;
        this.loginConn = new LoginConnection(props.getLoginHost(), props.getLoginPort());
        this.password = props.getPassword();
        this.loginConn.addOscarListener(new LoginConnListener());
        this.loginConn.setServiceFactory(new LoginServiceFactory());
    }

    public synchronized State getState() {
        return this.state;
    }

    public synchronized StateInfo getStateInfo() {
        return this.stateInfo;
    }

    public void addStateListener(StateListener l) {
        DefensiveTools.checkNull((Object)l, (String)"l");
        this.stateListeners.addIfAbsent((Object)l);
    }

    public void removeStateListener(StateListener l) {
        DefensiveTools.checkNull((Object)l, (String)"l");
        this.stateListeners.remove((Object)l);
    }

    public synchronized boolean getTriedConnecting() {
        return this.triedConnecting;
    }

    private synchronized boolean setTriedConnecting() {
        if (this.triedConnecting) {
            return false;
        }
        this.triedConnecting = true;
        return true;
    }

    public boolean connect() {
        this.setTriedConnecting();
        this.loginConn.getClientFlapConn().setSocketFactory(this.aimConnection.getProxy().getSocketFactory());
        this.loginConn.connect();
        this.setState(State.NOTCONNECTED, State.CONNECTINGAUTH, new AuthorizingStateInfo(this.loginConn));
        return true;
    }

    public void disconnect() {
        this.disconnect(true);
    }

    public synchronized void disconnect(boolean onPurpose) {
        this.wantedDisconnect = onPurpose;
        this.closeConnections();
    }

    public synchronized boolean wantedDisconnect() {
        return this.wantedDisconnect;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean setState(State expectedOld, State state, StateInfo info) {
        StateInfo oldStateInfo;
        State oldState;
        DefensiveTools.checkNull((Object)state, (String)"state");
        DefensiveTools.checkNull((Object)info, (String)"info");
        LOGGER.fine("New state: " + state + " - " + info);
        ConnectionManager connectionManager = this;
        synchronized (connectionManager) {
            oldState = this.state;
            oldStateInfo = this.stateInfo;
            if (expectedOld != null && oldState != expectedOld) {
                LOGGER.warning("Tried converting state " + expectedOld + " to " + state + ", but was in " + oldState);
                return false;
            }
            this.state = state;
            this.stateInfo = info;
        }
        StateEvent event = new StateEvent(this.aimConnection, oldState, oldStateInfo, state, info);
        for (StateListener listener : this.stateListeners) {
            listener.handleStateChange(event);
        }
        return true;
    }

    private void connectBos(LoginSuccessInfo info) {
        BasicConnection mainConn = this.prepareMainConn(info);
        mainConn.connect();
        this.setState(State.AUTHORIZING, State.CONNECTING, new ConnectingStateInfo(info));
    }

    private synchronized BasicConnection prepareMainConn(LoginSuccessInfo info) {
        if (this.state != State.AUTHORIZING) {
            throw new IllegalStateException("tried to connect to BOS server in state " + this.state);
        }
        BasicConnection mainConn = new BasicConnection(info.getServer(), info.getPort());
        mainConn.getClientFlapConn().setSocketFactory(this.aimConnection.getProxy().getSocketFactory());
        mainConn.setCookie(info.getCookie());
        mainConn.addOscarListener(new MainBosConnListener());
        mainConn.setServiceFactory(new BasicServiceFactory());
        this.mainConn = mainConn;
        return mainConn;
    }

    private void internalDisconnected() {
        this.setState(null, State.DISCONNECTED, new DisconnectedStateInfo(this.wantedDisconnect()));
        this.closeConnections();
    }

    private synchronized void closeConnections() {
        this.loginConn.disconnect();
        BasicConnection mainConn = this.mainConn;
        if (mainConn != null) {
            mainConn.disconnect();
        }
    }

    private class MainBosConnListener
    extends DefaultConnListener {
        private MainBosConnListener() {
        }

        public void allFamiliesReady(OscarConnection conn) {
            super.allFamiliesReady(conn);
            if (ConnectionManager.this.getState() == State.CONNECTING) {
                LOGGER.finer("State was CONNECTING, but now we're ONLINE. The state should've been SIGNINGON.");
                ConnectionManager.this.setState(State.CONNECTING, State.SIGNINGON, new SigningOnStateInfo());
            }
            ConnectionManager.this.setState(State.SIGNINGON, State.ONLINE, new OnlineStateInfo());
        }

        public void connStateChanged(OscarConnection conn, OscarConnStateEvent event) {
            ClientConn.State state = event.getClientConnEvent().getNewState();
            if (state == ClientConn.STATE_FAILED) {
                ConnectionManager.this.setState(null, State.FAILED, new ConnectionFailedStateInfo(conn.getHost(), conn.getPort()));
            } else if (state == ClientConn.STATE_NOT_CONNECTED) {
                ConnectionManager.this.internalDisconnected();
            } else if (state == ClientConn.STATE_CONNECTED) {
                ConnectionManager.this.setState(State.CONNECTING, State.SIGNINGON, new SigningOnStateInfo());
            }
        }
    }

    private class LoginProcessListener
    implements LoginServiceListener {
        private LoginProcessListener() {
        }

        public void loginSucceeded(LoginSuccessInfo info) {
            ConnectionManager.this.connectBos(info);
        }

        public void loginFailed(LoginFailureInfo info) {
            ConnectionManager.this.setState(null, State.FAILED, new LoginFailureStateInfo(info));
        }
    }

    private class LoginConnListener
    extends DefaultConnListener {
        private LoginConnListener() {
        }

        public void registeredSnacFamilies(OscarConnection conn) {
            super.registeredSnacFamilies(conn);
            LoginService ls = ConnectionManager.this.loginConn.getLoginService();
            ls.addLoginListener(new LoginProcessListener());
        }

        public void connStateChanged(OscarConnection conn, OscarConnStateEvent event) {
            ClientConn.State state = event.getClientConnEvent().getNewState();
            if (state == ClientConn.STATE_CONNECTED) {
                ConnectionManager.this.setState(State.CONNECTINGAUTH, State.AUTHORIZING, new AuthorizingStateInfo(ConnectionManager.this.loginConn));
            }
        }
    }

    private class DefaultConnListener
    implements OscarConnListener {
        private DefaultConnListener() {
        }

        public void registeredSnacFamilies(OscarConnection conn) {
            ConnectionManager.this.aimConnection.recordSnacFamilies(conn);
        }

        public void connStateChanged(OscarConnection conn, OscarConnStateEvent event) {
        }

        public void allFamiliesReady(OscarConnection conn) {
        }
    }

    private class BasicServiceFactory
    implements ServiceFactory {
        private BasicServiceFactory() {
        }

        public Service getService(OscarConnection conn, int family) {
            if (family == 1) {
                return new MainBosService(ConnectionManager.this.aimConnection, conn);
            }
            if (family == 4) {
                return new IcbmService(ConnectionManager.this.aimConnection, conn);
            }
            if (family == 3) {
                return new BuddyService(ConnectionManager.this.aimConnection, conn);
            }
            if (family == 2) {
                return new InfoService(ConnectionManager.this.aimConnection, conn);
            }
            if (family == 19) {
                return new SsiService(ConnectionManager.this.aimConnection, conn);
            }
            LOGGER.warning("No service for family 0x" + Integer.toHexString(family));
            return null;
        }
    }

    private class LoginServiceFactory
    implements ServiceFactory {
        private LoginServiceFactory() {
        }

        public Service getService(OscarConnection conn, int family) {
            if (family == 23) {
                return new LoginService(ConnectionManager.this.aimConnection, ConnectionManager.this.loginConn, ConnectionManager.this.aimConnection.getScreenname(), ConnectionManager.this.password);
            }
            return null;
        }
    }
}

