/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joustsim.oscar;

import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.ratelim.ConnectionQueueMgr;
import net.kano.joscar.ratelim.RateQueue;
import net.kano.joscar.snac.CmdType;
import net.kano.joustsim.Screenname;
import net.kano.joustsim.oscar.AimConnection;
import net.kano.joustsim.oscar.BuddyInfo;
import net.kano.joustsim.oscar.BuddyInfoManager;
import net.kano.joustsim.oscar.BuddyInfoTrackerListener;
import net.kano.joustsim.oscar.GlobalBuddyInfoListener;
import net.kano.joustsim.oscar.OpenedServiceListener;
import net.kano.joustsim.oscar.State;
import net.kano.joustsim.oscar.oscar.OscarConnection;
import net.kano.joustsim.oscar.oscar.service.Service;
import net.kano.joustsim.oscar.oscar.service.info.InfoService;
import net.kano.joustsim.oscar.oscar.service.ssi.Buddy;
import net.kano.joustsim.oscar.oscar.service.ssi.BuddyList;
import net.kano.joustsim.oscar.oscar.service.ssi.BuddyListLayoutListener;
import net.kano.joustsim.oscar.oscar.service.ssi.Group;
import net.kano.joustsim.oscar.oscar.service.ssi.SsiService;
import net.kano.joustsim.trust.BuddyCertificateInfo;

public class BuddyInfoTracker {
    private static final Logger LOGGER = Logger.getLogger(BuddyInfoTracker.class.getName());
    public static final long DEFAULT_MINIMUM_TRACK_INTERVAL = 30000L;
    private final AimConnection conn;
    private final BuddyInfoManager buddyInfoMgr;
    private Map<Screenname, TrackedBuddyInfo> trackers = new HashMap<Screenname, TrackedBuddyInfo>();
    private boolean initializedSsi = false;
    private Set<Screenname> buddies = new HashSet<Screenname>();
    private long minimumTrackInterval = 30000L;
    private final Thread thread;
    private Comparator<TrackedBuddyInfo> lastCheckedComparator = new Comparator<TrackedBuddyInfo>(){

        @Override
        public int compare(TrackedBuddyInfo o1, TrackedBuddyInfo o2) {
            if (o1.lastChecked < o2.lastChecked) {
                return 1;
            }
            if (o1.lastChecked > o2.lastChecked) {
                return -1;
            }
            return 0;
        }
    };

    public BuddyInfoTracker(AimConnection connection) {
        BuddyInfoManager buddyInfoMgr;
        DefensiveTools.checkNull((Object)connection, (String)"connection");
        this.conn = connection;
        this.buddyInfoMgr = buddyInfoMgr = connection.getBuddyInfoManager();
        connection.addOpenedServiceListener(new OpenedServiceListener(){

            @Override
            public void openedServices(AimConnection conn, Collection<? extends Service> services) {
                SsiService ssi;
                if (!BuddyInfoTracker.this.initializedSsi && (ssi = conn.getSsiService()) != null) {
                    BuddyInfoTracker.this.initializedSsi = true;
                    ssi.getBuddyList().addLayoutListener(new BuddyListLayoutListener(){

                        @Override
                        public void groupsReordered(BuddyList list, List<? extends Group> oldOrder, List<? extends Group> newOrder) {
                        }

                        @Override
                        public void groupAdded(BuddyList list, List<? extends Group> oldItems, List<? extends Group> newItems, Group group, List<? extends Buddy> buddies) {
                            BuddyInfoTracker.this.handleBuddiesUpdated();
                        }

                        @Override
                        public void groupRemoved(BuddyList list, List<? extends Group> oldItems, List<? extends Group> newItems, Group group) {
                            BuddyInfoTracker.this.handleBuddiesUpdated();
                        }

                        @Override
                        public void buddyAdded(BuddyList list, Group group, List<? extends Buddy> oldItems, List<? extends Buddy> newItems, Buddy buddy) {
                            BuddyInfoTracker.this.handleBuddiesUpdated();
                        }

                        @Override
                        public void buddyRemoved(BuddyList list, Group group, List<? extends Buddy> oldItems, List<? extends Buddy> newItems, Buddy buddy) {
                            BuddyInfoTracker.this.handleBuddiesUpdated();
                        }

                        @Override
                        public void buddiesReordered(BuddyList list, Group group, List<? extends Buddy> oldBuddies, List<? extends Buddy> newBuddies) {
                        }
                    });
                }
            }

            @Override
            public void closedServices(AimConnection conn, Collection<? extends Service> services) {
            }
        });
        buddyInfoMgr.addGlobalBuddyInfoListener(new GlobalBuddyInfoListener(){

            public void newBuddyInfo(BuddyInfoManager manager, Screenname buddy, BuddyInfo info) {
            }

            public void buddyInfoChanged(BuddyInfoManager manager, Screenname buddy, BuddyInfo info, PropertyChangeEvent event) {
                InfoService infoService;
                BuddyCertificateInfo certInfo;
                if (!BuddyInfoTracker.this.isTracked(buddy)) {
                    return;
                }
                String prop = event.getPropertyName();
                if (prop.equals("certificateInfo") && (certInfo = (BuddyCertificateInfo)event.getNewValue()) != null && !certInfo.isUpToDate() && (infoService = BuddyInfoTracker.this.getInfoService()) != null) {
                    infoService.requestCertificateInfo(buddy);
                }
            }

            public void receivedStatusUpdate(BuddyInfoManager manager, Screenname buddy, BuddyInfo info) {
                InfoService infoService;
                if (!BuddyInfoTracker.this.isTracked(buddy)) {
                    return;
                }
                if (info.isAway() && (infoService = BuddyInfoTracker.this.getInfoService()) != null) {
                    infoService.requestAwayMessage(buddy);
                }
            }
        });
        this.thread = new Thread(new TrackingThread());
        this.thread.setDaemon(true);
        this.thread.start();
    }

    private synchronized void handleBuddiesUpdated() {
        SsiService ssi = this.conn.getSsiService();
        if (ssi != null) {
            HashSet<Screenname> old = new HashSet<Screenname>(this.buddies);
            this.buddies.clear();
            for (Group group : ssi.getBuddyList().getGroups()) {
                for (Buddy buddy : group.getBuddiesCopy()) {
                    Screenname sn = buddy.getScreenname();
                    this.buddyInfoMgr.getBuddyInfo(sn).setOnBuddyList(true);
                    this.buddies.add(sn);
                }
            }
            old.removeAll(this.buddies);
            for (Screenname screenname : old) {
                this.buddyInfoMgr.getBuddyInfo(screenname).setOnBuddyList(false);
            }
        }
    }

    private InfoService getInfoService() {
        return this.conn.getInfoService();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addTracker(Screenname buddy, BuddyInfoTrackerListener listener) {
        boolean added;
        DefensiveTools.checkNull((Object)buddy, (String)"buddy");
        DefensiveTools.checkNull((Object)listener, (String)"listener");
        boolean startTracking = false;
        BuddyInfoTracker buddyInfoTracker = this;
        synchronized (buddyInfoTracker) {
            TrackedBuddyInfo btrackers = this.trackers.get(buddy);
            if (btrackers == null) {
                btrackers = new TrackedBuddyInfo(buddy);
                this.trackers.put(buddy, btrackers);
                startTracking = true;
            }
            added = btrackers.addListener(listener);
        }
        assert (!startTracking || added);
        if (startTracking) {
            this.startTracking(buddy);
        }
        this.thread.interrupt();
        return added;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeTracker(Screenname buddy, BuddyInfoTrackerListener listener) {
        boolean stopTracking;
        DefensiveTools.checkNull((Object)buddy, (String)"buddy");
        DefensiveTools.checkNull((Object)listener, (String)"listener");
        BuddyInfoTracker buddyInfoTracker = this;
        synchronized (buddyInfoTracker) {
            TrackedBuddyInfo btrackers = this.trackers.get(buddy);
            if (btrackers == null) {
                return false;
            }
            boolean removed = btrackers.removeListener(listener);
            if (!removed) {
                return false;
            }
            stopTracking = btrackers.hasListeners();
            if (stopTracking) {
                this.trackers.remove(buddy);
            }
        }
        if (stopTracking) {
            this.stopTracking(buddy);
        }
        return true;
    }

    private void startTracking(Screenname buddy) {
        assert (!Thread.holdsLock(this));
        assert (this.isExplicitlyTracked(buddy));
        DefensiveTools.checkNull((Object)buddy, (String)"buddy");
        BuddyInfo buddyInfo = this.buddyInfoMgr.getBuddyInfo(buddy);
        InfoService infoService = this.getInfoService();
        if (!buddyInfo.isCertificateInfoCurrent()) {
            infoService.requestCertificateInfo(buddy);
        }
        if (buddyInfo.isAway() && buddyInfo.getAwayMessage() == null) {
            infoService.requestAwayMessage(buddy);
        }
    }

    private void stopTracking(Screenname buddy) {
        assert (!Thread.holdsLock(this));
        assert (!this.isExplicitlyTracked(buddy));
        DefensiveTools.checkNull((Object)buddy, (String)"buddy");
    }

    public synchronized boolean isTracked(Screenname sn) {
        if (sn.equals(this.conn.getScreenname())) {
            return true;
        }
        if (this.buddies.contains(sn)) {
            return true;
        }
        return this.isExplicitlyTracked(sn);
    }

    private synchronized boolean isExplicitlyTracked(Screenname sn) {
        return this.trackers.containsKey(sn);
    }

    public synchronized long getMinimumTrackInterval() {
        return this.minimumTrackInterval;
    }

    public synchronized void setMinimumTrackInterval(long minimumTrackInterval) {
        this.minimumTrackInterval = minimumTrackInterval;
    }

    private class TrackingThread
    implements Runnable {
        private TrackingThread() {
        }

        public void run() {
            while (BuddyInfoTracker.this.conn.getState() != State.FAILED && BuddyInfoTracker.this.conn.getState() != State.DISCONNECTED) {
                try {
                    this.becool();
                }
                catch (Exception e) {
                    LOGGER.log(Level.WARNING, "Error running buddy tracker", e);
                }
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException interruptedException) {}
            }
            LOGGER.fine("Shutting down buddy tracker thread for " + BuddyInfoTracker.this.conn);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void becool() {
            ArrayList<Screenname> request;
            InfoService infoService = BuddyInfoTracker.this.conn.getInfoService();
            if (infoService == null) {
                return;
            }
            OscarConnection oscar = infoService.getOscarConnection();
            ConnectionQueueMgr queueMgr = oscar.getRateManager().getQueueMgr(oscar.getSnacProcessor());
            RateQueue infoQueue = queueMgr.getRateQueue(new CmdType(2, 21));
            if (infoQueue == null) {
                return;
            }
            long now = System.currentTimeMillis();
            BuddyInfoTracker buddyInfoTracker = BuddyInfoTracker.this;
            synchronized (buddyInfoTracker) {
                TreeSet<TrackedBuddyInfo> want = new TreeSet<TrackedBuddyInfo>(BuddyInfoTracker.this.lastCheckedComparator);
                for (TrackedBuddyInfo info : BuddyInfoTracker.this.trackers.values()) {
                    if (BuddyInfoTracker.this.buddyInfoMgr.getBuddyInfo(info.screenname).isOnBuddyList() || now - info.lastChecked <= BuddyInfoTracker.this.minimumTrackInterval) continue;
                    want.add(info);
                }
                request = new ArrayList<Screenname>();
                int possible = infoQueue.getRateClassMonitor().getPossibleCmdCount() - 1;
                int i = 0;
                for (TrackedBuddyInfo info : want) {
                    if (i >= possible) break;
                    LOGGER.fine("Requesting tracked buddy " + info.screenname + "'s awaymsg after " + (now - info.lastChecked / 1000L) + "sec");
                    info.lastChecked = now;
                    request.add(info.screenname);
                    ++i;
                }
            }
            for (Screenname screenname : request) {
                infoService.requestAwayMessage(screenname);
            }
        }
    }

    private class TrackedBuddyInfo {
        private final Screenname screenname;
        public volatile long lastChecked = 0L;
        public final Set<BuddyInfoTrackerListener> trackers = new HashSet<BuddyInfoTrackerListener>();

        public TrackedBuddyInfo(Screenname screenname) {
            this.screenname = screenname;
        }

        public boolean addListener(BuddyInfoTrackerListener listener) {
            assert (Thread.holdsLock(BuddyInfoTracker.this));
            return this.trackers.add(listener);
        }

        public boolean removeListener(BuddyInfoTrackerListener listener) {
            assert (Thread.holdsLock(BuddyInfoTracker.this));
            return this.trackers.remove(listener);
        }

        public boolean hasListeners() {
            assert (Thread.holdsLock(BuddyInfoTracker.this));
            return this.trackers.isEmpty();
        }
    }
}

